/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooUiPlugin;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class BambooImages {
    private static final URL BASE_URL = BambooUiPlugin.getDefault().getBundle().getEntry("/icons/");
    private static final IPath ICONS_PATH = new Path("$nl$/icons");
    private static final String T_OBJ = "obj16";
    public static final ImageDescriptor STATUS_DISABLED = BambooImages.create("obj16", "icn_plan_disabled.gif");
    public static final ImageDescriptor STATUS_FAILED = BambooImages.create("obj16", "icn_plan_failed.gif");
    public static final ImageDescriptor STATUS_PASSED = BambooImages.create("obj16", "icn_plan_passed.gif");
    public static final ImageDescriptor[] STATUS_BUILDING = new ImageDescriptor[]{BambooImages.create("obj16", "icn_building_1.gif"), BambooImages.create("obj16", "icn_building_2.gif"), BambooImages.create("obj16", "icn_building_3.gif"), BambooImages.create("obj16", "icn_building_4.gif"), BambooImages.create("obj16", "icn_building_5.gif"), BambooImages.create("obj16", "icn_building_6.gif"), BambooImages.create("obj16", "icn_building_7.gif"), BambooImages.create("obj16", "icn_building_8.gif")};
    public static final ImageDescriptor VIEW_STATUS_WARNING = BambooImages.create("obj16", "bamboo_warning.png");
    public static final ImageDescriptor VIEW_STATUS_FAILED = BambooImages.create("obj16", "bamboo_error.png");
    public static final ImageDescriptor VIEW_STATUS_PASSED = BambooImages.create("obj16", "bamboo_success.png");
    public static final ImageDescriptor BAMBOO = BambooImages.create("obj16", "bamboo.png");
    public static final ImageDescriptor CONSOLE = BambooImages.create("obj16", "console_view.gif");
    public static final ImageDescriptor JUNIT = BambooImages.create("obj16", "junit.gif");
    public static final ImageDescriptor RUN_BUILD = BambooImages.create("obj16", "run_exc.gif");
    public static final ImageDescriptor ADD_REPOSITORY = BambooImages.create("obj16", "repository-new.gif");
    public static final ImageDescriptor REPOSITORY = BambooImages.create("obj16", "bamboo_repository.gif");
    public static final ImageDescriptor REPOSITORIES = BambooImages.create("obj16", "repositories.gif");

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)BambooImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(BASE_URL, buffer.toString());
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        IPath path = ICONS_PATH.append(relativePath);
        return BambooImages.createImageDescriptor(BambooUiPlugin.getDefault().getBundle(), path, true);
    }

    private static ImageDescriptor createImageDescriptor(Bundle bundle, IPath path, boolean useMissingImageDescriptor) {
        URL url = FileLocator.find((Bundle)bundle, (IPath)path, null);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        if (useMissingImageDescriptor) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
        return null;
    }
}

