/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationRule;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.Variable;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules.WebflowValidationRuleUtils;
import org.springframework.util.StringUtils;

public class VariableValidationRule
implements IValidationRule<Variable, WebflowValidationContext> {
    public boolean supports(IModelElement element, IValidationContext context) {
        return element instanceof Variable && context instanceof WebflowValidationContext;
    }

    public void validate(Variable attribute, WebflowValidationContext context, IProgressMonitor monitor) {
        if (context.isVersion1()) {
            if (!StringUtils.hasText((String)attribute.getName())) {
                context.error(attribute, "NO_NAME_ATTRIBUTE", "Element 'var' requires 'name' attribute", new ValidationProblemAttribute[0]);
            } else if (!(StringUtils.hasText((String)attribute.getBean()) || StringUtils.hasText((String)attribute.getClazz()) || WebflowModelUtils.isReferencedBeanFound(context.getWebflowConfig(), attribute.getName()))) {
                context.error(attribute, "INVALID_BEAN", MessageUtils.format((String)"Referenced bean \"{0}\" cannot be found", (Object)attribute.getName()), new ValidationProblemAttribute[0]);
            }
            if (StringUtils.hasText((String)attribute.getScope()) && !WebflowValidationRuleUtils.SCOPE_TYPES.contains(attribute.getScope())) {
                context.error(attribute, "INVALID_SCOPE", MessageUtils.format((String)"Invalid scope \"{0}\" specified", (Object)attribute.getScope()), new ValidationProblemAttribute[0]);
            }
            this.checkClassAttribute(attribute, context);
            if (StringUtils.hasText((String)attribute.getBean()) && !WebflowModelUtils.isReferencedBeanFound(context.getWebflowConfig(), attribute.getBean())) {
                context.error(attribute, "INVALID_BEAN", MessageUtils.format((String)"Referenced bean \"{0}\" cannot be found", (Object)attribute.getBean()), new ValidationProblemAttribute[0]);
            }
        } else {
            this.checkNameAttribute(attribute, context);
            this.checkClassAttribute(attribute, context);
        }
    }

    private void checkNameAttribute(Variable attribute, WebflowValidationContext context) {
        if (!StringUtils.hasText((String)attribute.getName())) {
            context.error(attribute, "NO_NAME_ATTRIBUTE", "Element 'var' requires 'name' attribute", new ValidationProblemAttribute[0]);
        }
    }

    private void checkClassAttribute(Variable attribute, WebflowValidationContext context) {
        if (StringUtils.hasText((String)attribute.getClazz())) {
            IType type = WebflowValidationRuleUtils.getJavaType(attribute.getClazz(), context);
            if (type == null) {
                context.error(attribute, "INVALID_TYPE", MessageUtils.format((String)"Class 'var' \"{0}\" cannot be resolved", (Object)attribute.getClazz()), new ValidationProblemAttribute[0]);
            } else {
                try {
                    if (type.isInterface() || Flags.isAbstract((int)type.getFlags())) {
                        context.error(attribute, "INVALID_TYPE", MessageUtils.format((String)"Class 'var' \"{0}\" is either an Interface or abstract", (Object)attribute.getClazz()), new ValidationProblemAttribute[0]);
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
        }
    }
}

