/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.springframework.ide.eclipse.core.PersistablePreferenceObjectSupport;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinitionFactory;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinition;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidatorDefinitionFactory;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.ui.SpringUIImages;
import org.springframework.ide.eclipse.ui.SpringUIMessages;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;
import org.springframework.ide.eclipse.ui.dialogs.ValidationRuleConfigurationDialog;

public class ProjectValidatorPropertyTab {
    private ITreeContentProvider contentProvider;
    private List<ValidatorDefinition> validatorDefinitions;
    private Map<ValidatorDefinition, List<ValidationRuleDefinition>> validationRuleDefinitions;
    private CheckboxTreeViewer validatorViewer;
    private Text descriptionText;
    private IProject project;
    private Shell shell;
    private Button configureButton;
    private Button resetButton;
    private Map<ValidationRuleDefinition, Map<String, String>> changedPropertyValues = new HashMap<ValidationRuleDefinition, Map<String, String>>();
    private Map<ValidationRuleDefinition, Map<String, Integer>> changedMessageSeverities = new HashMap<ValidationRuleDefinition, Map<String, Integer>>();
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            ProjectValidatorPropertyTab.this.handleButtonPressed((Button)e.widget);
        }
    };
    private SelectionListener resetListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if ((Button)e.widget == ProjectValidatorPropertyTab.this.resetButton) {
                ProjectValidatorPropertyTab.this.performDefaults();
            }
        }
    };
    private Object[] checkedElements;

    public ProjectValidatorPropertyTab(Shell shell, IProject project) {
        this.validatorDefinitions = ValidatorDefinitionFactory.getValidatorDefinitions();
        this.validationRuleDefinitions = new HashMap<ValidatorDefinition, List<ValidationRuleDefinition>>();
        for (ValidatorDefinition def : this.validatorDefinitions) {
            ArrayList rules = new ArrayList();
            rules.addAll(ValidationRuleDefinitionFactory.getRuleDefinitions((String)def.getID()));
            Collections.sort(rules, new Comparator<ValidationRuleDefinition>(){

                @Override
                public int compare(ValidationRuleDefinition o1, ValidationRuleDefinition o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.validationRuleDefinitions.put(def, rules);
        }
        this.project = project;
        this.shell = shell;
    }

    protected void handleButtonPressed(Button widget) {
        Object obj;
        IStructuredSelection selection;
        if (widget == this.configureButton && !(selection = (IStructuredSelection)this.validatorViewer.getSelection()).isEmpty() && (obj = selection.getFirstElement()) instanceof ValidationRuleDefinition) {
            ValidationRuleDefinition ruleDef = (ValidationRuleDefinition)obj;
            HashMap<String, String> propertyValues = null;
            propertyValues = this.changedPropertyValues.containsKey(ruleDef) ? new HashMap<String, String>(this.changedPropertyValues.get(ruleDef)) : new HashMap(ruleDef.getPropertyValues());
            HashMap<String, Integer> messageSeverities = null;
            messageSeverities = this.changedMessageSeverities.containsKey(ruleDef) ? new HashMap<String, Integer>(this.changedMessageSeverities.get(ruleDef)) : new HashMap(ruleDef.getMessageSeverities());
            ValidationRuleConfigurationDialog dialog = new ValidationRuleConfigurationDialog(this.shell, propertyValues, messageSeverities, ruleDef);
            if (dialog.open() == 0) {
                this.changedPropertyValues.put(ruleDef, propertyValues);
                this.changedMessageSeverities.put(ruleDef, messageSeverities);
            }
        }
    }

    public Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 3;
        layout.marginWidth = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        if (this.project != null) {
            Label beansLabel = new Label(composite, 0);
            beansLabel.setText(SpringUIMessages.ProjectValidatorPropertyPage_description);
        }
        Composite tableAndButtons = new Composite(composite, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.validatorViewer = new CheckboxTreeViewer(tableAndButtons);
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        this.contentProvider = new ProjectValidatorContentProvider(this.validatorDefinitions, this.validationRuleDefinitions);
        this.validatorViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.validatorViewer.setLabelProvider((IBaseLabelProvider)new ProjectBuilderLabelProvider());
        this.validatorViewer.setInput((Object)this);
        GridData data = new GridData(1808);
        data.heightHint = 150;
        this.validatorViewer.getControl().setLayoutData((Object)data);
        this.validatorViewer.getControl().setFont(font);
        this.validatorViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    if (sel.getFirstElement() == null) {
                        ProjectValidatorPropertyTab.this.clearDescription();
                    } else {
                        ProjectValidatorPropertyTab.this.showDescription(sel.getFirstElement());
                    }
                    ProjectValidatorPropertyTab.this.updateConfigureButtonEnablement(sel.getFirstElement());
                }
            }
        });
        this.validatorViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ProjectValidatorPropertyTab.this.handleCheckStateChange(event);
                ProjectValidatorPropertyTab.this.checkedElements = ProjectValidatorPropertyTab.this.validatorViewer.getCheckedElements();
            }
        });
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.configureButton = new Button(buttonArea, 8);
        this.configureButton.setText("Configure");
        this.configureButton.setEnabled(false);
        this.configureButton.addSelectionListener(this.buttonListener);
        Label descriptionLabel = new Label(composite, 0);
        descriptionLabel.setText(SpringUIMessages.ProjectValidatorPropertyPage_builderDescription);
        this.descriptionText = new Text(composite, 2378);
        data = new GridData(1808);
        data.heightHint = 30;
        this.descriptionText.setLayoutData((Object)data);
        this.resetButton = new Button(composite, 8);
        this.resetButton.setText("Restore Defaults");
        data = new GridData(128);
        this.resetButton.setLayoutData((Object)data);
        this.resetButton.addSelectionListener(this.resetListener);
        this.initializeCheckedState(this.project, false);
        return composite;
    }

    private void handleCheckStateChange(final CheckStateChangedEvent event) {
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                boolean state = event.getChecked();
                ProjectValidatorPropertyTab.this.setSubtreeChecked(event.getElement(), state, true);
                ProjectValidatorPropertyTab.this.updateParentState(event.getElement());
            }
        });
    }

    private void updateParentState(Object child) {
        if (child == null || this.contentProvider.getParent(child) == null) {
            return;
        }
        Object parent = this.contentProvider.getParent(child);
        boolean childChecked = false;
        Object[] members = this.contentProvider.getChildren(parent);
        int i = members.length - 1;
        while (i >= 0) {
            if (this.validatorViewer.getChecked(members[i]) || this.validatorViewer.getGrayed(members[i])) {
                childChecked = true;
                break;
            }
            --i;
        }
        this.validatorViewer.setGrayChecked(parent, childChecked);
        this.updateParentState(parent);
    }

    private void setSubtreeChecked(Object container, boolean state, boolean checkExpandedState) {
        Object[] members = this.contentProvider.getChildren(container);
        int i = members.length - 1;
        while (i >= 0) {
            boolean elementGrayChecked;
            Object element = members[i];
            boolean bl = elementGrayChecked = this.validatorViewer.getGrayed(element) || this.validatorViewer.getChecked(element);
            if (state) {
                this.validatorViewer.setChecked(element, true);
                this.validatorViewer.setGrayed(element, false);
            } else {
                this.validatorViewer.setGrayChecked(element, false);
            }
            if (state || elementGrayChecked) {
                this.setSubtreeChecked(element, state, true);
            }
            --i;
        }
    }

    private List<PersistablePreferenceObjectSupport> getEnabledProjectBuilderDefinitions(IProject project, boolean getDefault) {
        List<ValidatorDefinition> validatorDefinitions = this.validatorDefinitions;
        ArrayList<PersistablePreferenceObjectSupport> filteredValidatorDefinitions = new ArrayList<PersistablePreferenceObjectSupport>();
        for (ValidatorDefinition validatorDefinition : validatorDefinitions) {
            if (!(getDefault ? validatorDefinition.isEnabledByDefault() : validatorDefinition.isEnabled(project))) continue;
            filteredValidatorDefinitions.add((PersistablePreferenceObjectSupport)validatorDefinition);
        }
        for (List list : this.validationRuleDefinitions.values()) {
            for (ValidationRuleDefinition def : list) {
                if (!(getDefault ? def.isEnabledByDefault() : def.isEnabled(project))) continue;
                filteredValidatorDefinitions.add((PersistablePreferenceObjectSupport)def);
            }
        }
        return filteredValidatorDefinitions;
    }

    private void showDescription(Object definition) {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        String text = null;
        if (definition instanceof ValidatorDefinition) {
            text = ((ValidatorDefinition)definition).getDescription();
        } else if (definition instanceof ValidationRuleDefinition) {
            text = ((ValidationRuleDefinition)definition).getDescription();
        }
        if (text == null || text.length() == 0) {
            this.descriptionText.setText(SpringUIMessages.ProjectValidatorPropertyPage_noBuilderDescription);
        } else {
            this.descriptionText.setText(text);
        }
    }

    private void initializeCheckedState(final IProject project, final boolean getDefault) {
        BusyIndicator.showWhile((Display)this.shell.getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                List items = ProjectValidatorPropertyTab.this.getEnabledProjectBuilderDefinitions(project, getDefault);
                ProjectValidatorPropertyTab.this.validatorViewer.setCheckedElements(items.toArray());
                int i = 0;
                while (i < items.size()) {
                    Object item = items.get(i);
                    ProjectValidatorPropertyTab.this.updateParentState(item);
                    ++i;
                }
                ProjectValidatorPropertyTab.this.checkedElements = ProjectValidatorPropertyTab.this.validatorViewer.getCheckedElements();
            }
        });
    }

    private void clearDescription() {
        if (this.descriptionText == null || this.descriptionText.isDisposed()) {
            return;
        }
        this.descriptionText.setText("");
    }

    private void updateConfigureButtonEnablement(Object firstElement) {
        if (firstElement instanceof ValidationRuleDefinition && (((ValidationRuleDefinition)firstElement).getPropertyValues().size() > 0 || ((ValidationRuleDefinition)firstElement).getMessageSeverities().size() > 0)) {
            this.configureButton.setEnabled(true);
        } else {
            this.configureButton.setEnabled(false);
        }
    }

    public void performDefaults() {
        this.initializeCheckedState(null, true);
        for (List<ValidationRuleDefinition> defList : this.validationRuleDefinitions.values()) {
            for (ValidationRuleDefinition ruleDef : defList) {
                this.changedPropertyValues.put(ruleDef, ruleDef.getDefaultPropertyValues());
                this.changedMessageSeverities.put(ruleDef, ruleDef.getDefaultMessageSeverities());
            }
        }
    }

    public boolean performOk() {
        final List checkElements = this.checkedElements != null ? Arrays.asList(this.checkedElements) : Collections.emptyList();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                for (Map.Entry def : ProjectValidatorPropertyTab.this.validationRuleDefinitions.entrySet()) {
                    boolean enableValidator = false;
                    for (ValidationRuleDefinition rule : (List)def.getValue()) {
                        if (checkElements.contains(rule)) {
                            enableValidator = true;
                            rule.setEnabled(true, ProjectValidatorPropertyTab.this.project);
                        } else {
                            rule.setEnabled(false, ProjectValidatorPropertyTab.this.project);
                        }
                        if (!ProjectValidatorPropertyTab.this.changedPropertyValues.containsKey(rule) && !ProjectValidatorPropertyTab.this.changedMessageSeverities.containsKey(rule)) continue;
                        rule.setSpecificConfiguration((Map)ProjectValidatorPropertyTab.this.changedPropertyValues.get(rule), (Map)ProjectValidatorPropertyTab.this.changedMessageSeverities.get(rule), ProjectValidatorPropertyTab.this.project);
                    }
                    ((ValidatorDefinition)def.getKey()).setEnabled(enableValidator, ProjectValidatorPropertyTab.this.project);
                }
            }
        };
        try {
            operation.run((IProgressMonitor)new NullProgressMonitor());
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    private static class ProjectBuilderLabelProvider
    extends LabelProvider {
        private ProjectBuilderLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ValidatorDefinition) {
                return ((ValidatorDefinition)element).getName();
            }
            if (element instanceof ValidationRuleDefinition) {
                return ((ValidationRuleDefinition)element).getName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            Image image = null;
            if (element instanceof ValidatorDefinition) {
                String icon = ((ValidatorDefinition)element).getIconUri();
                String ns = ((ValidatorDefinition)element).getNamespaceUri();
                if (icon != null && ns != null && (image = SpringUIPlugin.getDefault().getImageRegistry().get(icon)) == null) {
                    ImageDescriptor imageDescriptor = SpringUIPlugin.imageDescriptorFromPlugin((String)ns, (String)icon);
                    SpringUIPlugin.getDefault().getImageRegistry().put(icon, imageDescriptor);
                    image = SpringUIPlugin.getDefault().getImageRegistry().get(icon);
                }
            }
            if (image == null) {
                return SpringUIImages.getImage("org.springframework.ide.eclipse.ui.rule_obj.gif");
            }
            return image;
        }
    }

    private static class ProjectValidatorContentProvider
    implements ITreeContentProvider {
        private List<ValidatorDefinition> validatorDefinitions;
        private Map<ValidatorDefinition, List<ValidationRuleDefinition>> validationRuleDefinitions;

        public ProjectValidatorContentProvider(List<ValidatorDefinition> validatorDefinitions, Map<ValidatorDefinition, List<ValidationRuleDefinition>> validationRuleDefinitions) {
            this.validatorDefinitions = validatorDefinitions;
            this.validationRuleDefinitions = validationRuleDefinitions;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return this.validatorDefinitions.toArray();
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ValidatorDefinition) {
                return this.validationRuleDefinitions.get((ValidatorDefinition)parentElement).toArray();
            }
            return IModelElement.NO_CHILDREN;
        }

        public Object getParent(Object element) {
            if (element instanceof ValidationRuleDefinition) {
                for (ValidatorDefinition def : this.validatorDefinitions) {
                    if (!((ValidationRuleDefinition)element).getValidatorId().equals(def.getID())) continue;
                    return def;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }
}

