/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.model;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.ide.eclipse.core.MarkerUtils;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.ide.eclipse.core.model.xml.XmlSourceLocation;

public final class ModelUtils {
    public static boolean isExternal(IModelElement element, IModelElement context) {
        if (context instanceof IResourceModelElement && element instanceof IResourceModelElement) {
            IProject contextProject = ((IResourceModelElement)context).getElementResource().getProject();
            IProject elementProject = ((IResourceModelElement)element).getElementResource().getProject();
            if (!elementProject.equals((Object)contextProject)) {
                return true;
            }
        }
        return false;
    }

    public static IMarker createMarker(final IModelElement element) {
        IResource resource;
        if (element instanceof IResourceModelElement && (resource = ((IResourceModelElement)element).getElementResource()) != null) {
            try {
                final IMarker[] markers = new IMarker[1];
                IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) throws CoreException {
                        IMarker marker = resource.createMarker("org.eclipse.core.resources.textmarker");
                        marker.setAttribute("message", (Object)this.toString());
                        if (element instanceof ISourceModelElement) {
                            marker.setAttribute("lineNumber", ((ISourceModelElement)element).getElementStartLine());
                            marker.setAttribute("location", (Object)("line " + ((ISourceModelElement)element).getElementStartLine()));
                        }
                        markers[0] = marker;
                    }
                };
                resource.getWorkspace().run(runnable, null, 1, null);
                return markers[0];
            }
            catch (CoreException e) {
                SpringCore.log(e);
            }
        }
        return null;
    }

    public static void deleteProblemMarkers(IModelElement element) {
        if (element instanceof IResourceModelElement) {
            IResource resource = ((IResourceModelElement)element).getElementResource();
            MarkerUtils.deleteMarkers(resource, "org.springframework.ide.eclipse.core.problemmarker");
        }
    }

    public static String getResourcePath(IModelElement element) {
        IResource resource;
        if (element instanceof IResourceModelElement && (resource = ((IResourceModelElement)element).getElementResource()) != null) {
            return resource.getFullPath().toString();
        }
        return null;
    }

    public static IModelSourceLocation getSourceLocation(BeanMetadataElement element) {
        Object source;
        if (element != null && (source = element.getSource()) instanceof IModelSourceLocation) {
            return (IModelSourceLocation)source;
        }
        return null;
    }

    public static XmlSourceLocation getXmlSourceLocation(IModelElement element) {
        if (element instanceof ISourceModelElement) {
            IModelSourceLocation location = ((ISourceModelElement)element).getElementSourceLocation();
            if (location instanceof XmlSourceLocation) {
                return (XmlSourceLocation)location;
            }
            if (element.getElementParent() != null) {
                return ModelUtils.getXmlSourceLocation(element.getElementParent());
            }
        }
        return null;
    }

    public static String getNameSpaceURI(ISourceModelElement element) {
        XmlSourceLocation location = ModelUtils.getXmlSourceLocation(element);
        return location != null ? location.getNamespaceURI() : null;
    }

    public static String getLocalName(ISourceModelElement element) {
        XmlSourceLocation location = ModelUtils.getXmlSourceLocation(element);
        return location != null ? location.getLocalName() : null;
    }

    public static String getNodeName(ISourceModelElement element) {
        XmlSourceLocation location = ModelUtils.getXmlSourceLocation(element);
        return location != null ? location.getNodeName() : null;
    }
}

