/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.io.xml;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class LineNumberPreservingDOMParser
extends DOMParser {
    private static final String START_LINE = "startLine";
    private static final String END_LINE = "endLine";
    private XMLLocator locator;

    public LineNumberPreservingDOMParser() throws SAXException {
        this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
    }

    public static final int getStartLineNumber(Node node) {
        return LineNumberPreservingDOMParser.getLineNumberFromUserData(node, START_LINE);
    }

    public static final int getEndLineNumber(Node node) {
        return LineNumberPreservingDOMParser.getLineNumberFromUserData(node, END_LINE);
    }

    private static int getLineNumberFromUserData(Node node, String key) {
        return NodeLineNumberAccessor.getLineNumber(node, key);
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        this.locator = locator;
        super.startDocument(locator, encoding, namespaceContext, augs);
        this.addLineNumberToCurrentNode(START_LINE);
    }

    public void endDocument(Augmentations augs) throws XNIException {
        this.addLineNumberToCurrentNode(END_LINE);
        super.endDocument(augs);
    }

    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        super.startElement(element, attributes, augs);
        this.addLineNumberToCurrentNode(START_LINE);
    }

    public void endElement(QName element, Augmentations augs) throws XNIException {
        this.addLineNumberToCurrentNode(END_LINE);
        super.endElement(element, augs);
    }

    private void addLineNumberToCurrentNode(String key) throws XNIException {
        try {
            Node node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
            if (node != null) {
                int line = this.locator.getLineNumber();
                NodeLineNumberAccessor.setLineNumber(node, line, key);
            }
        }
        catch (SAXException e) {
            throw new XNIException((Exception)e);
        }
    }

    private static class LineNumbers {
        private int start = -1;
        private int end = -1;

        private LineNumbers() {
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }
    }

    private static class NodeLineNumberAccessor {
        private static ThreadLocal<Map<Node, LineNumbers>> LINE_NUMBERS = new ThreadLocal<Map<Node, LineNumbers>>(){

            @Override
            protected Map<Node, LineNumbers> initialValue() {
                return new WeakHashMap<Node, LineNumbers>();
            }
        };

        private NodeLineNumberAccessor() {
        }

        public static void setLineNumber(Node node, int line, String key) {
            LineNumbers lineNumbers = null;
            if (LINE_NUMBERS.get().containsKey(node)) {
                lineNumbers = LINE_NUMBERS.get().get(node);
            } else {
                lineNumbers = new LineNumbers();
                LINE_NUMBERS.get().put(node, lineNumbers);
            }
            if (LineNumberPreservingDOMParser.START_LINE.equals(key)) {
                lineNumbers.setStart(line);
            } else if (LineNumberPreservingDOMParser.END_LINE.equals(key)) {
                lineNumbers.setEnd(line);
            }
        }

        public static int getLineNumber(Node node, String key) {
            if (LINE_NUMBERS.get().containsKey(node)) {
                if (LineNumberPreservingDOMParser.START_LINE.equals(key)) {
                    return LINE_NUMBERS.get().get(node).getStart();
                }
                if (LineNumberPreservingDOMParser.END_LINE.equals(key)) {
                    return LINE_NUMBERS.get().get(node).getEnd();
                }
            }
            return -1;
        }
    }
}

