/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;

public class ConfusingConditionCheck
extends Check {
    public static final String MSG_KEY = "confusing.condition.check";
    private static final int MULTIPLY_FACTOR_FOR_ELSE_BLOCK = 4;
    private int multiplyFactorForElseBlocks = 4;
    private boolean ignoreInnerIf = true;
    private boolean ignoreSequentialIf = true;
    private boolean ignoreNullCaseInIf = true;
    private boolean ignoreThrowInElse = true;

    public void setIgnoreInnerIf(boolean aIgnoreInnerIf) {
        this.ignoreInnerIf = aIgnoreInnerIf;
    }

    public void setIgnoreSequentialIf(boolean ignoreSequentialIf) {
        this.ignoreSequentialIf = ignoreSequentialIf;
    }

    public void setIgnoreNullCaseInIf(boolean ignoreNullCaseInIf) {
        this.ignoreNullCaseInIf = ignoreNullCaseInIf;
    }

    public void setIgnoreThrowInElse(boolean ignoreThrowInElse) {
        this.ignoreThrowInElse = ignoreThrowInElse;
    }

    public void setMultiplyFactorForElseBlocks(int multiplyFactorForElseBlocks) {
        this.multiplyFactorForElseBlocks = multiplyFactorForElseBlocks;
    }

    public int[] getDefaultTokens() {
        return new int[]{83};
    }

    public void visitToken(DetailAST literalIf) {
        if (!(!ConfusingConditionCheck.isIfEndsWithElse(literalIf) || this.ignoreSequentialIf && ConfusingConditionCheck.isSequentialIf(literalIf) || this.ignoreInnerIf && ConfusingConditionCheck.isInnerIf(literalIf) || this.ignoreThrowInElse && ConfusingConditionCheck.isElseWithThrow(literalIf) || !this.isRatioBetweenIfAndElseBlockSuitable(literalIf) || this.ignoreNullCaseInIf && ConfusingConditionCheck.isIfWithNull(literalIf) || !ConfusingConditionCheck.isConditionAllNegative(literalIf))) {
            this.log(literalIf.getLineNo(), MSG_KEY, new Object[0]);
        }
    }

    private static boolean isIfEndsWithElse(DetailAST literalIf) {
        DetailAST lastChildAfterIf = literalIf.getLastChild();
        return lastChildAfterIf.getType() == 92;
    }

    private static boolean isSequentialIf(DetailAST literalIf) {
        DetailAST lastChildAfterIf = literalIf.getLastChild();
        boolean isSequentialIf = lastChildAfterIf.getFirstChild().getType() == 83;
        return isSequentialIf;
    }

    private static boolean isInnerIf(DetailAST literalIf) {
        DetailAST childIf = literalIf.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
        return childIf.branchContains(83);
    }

    private static boolean isElseWithThrow(DetailAST literalIf) {
        DetailAST lastChildAfterIf = literalIf.getLastChild();
        return lastChildAfterIf.getFirstChild().branchContains(90);
    }

    private boolean isRatioBetweenIfAndElseBlockSuitable(DetailAST literalIf) {
        boolean result = true;
        DetailAST lastChildAfterIf = literalIf.getLastChild();
        int linesOfCodeInIfBlock = ConfusingConditionCheck.getAmounOfCodeRowsInBlock(literalIf);
        int linesOfCodeInElseBlock = ConfusingConditionCheck.getAmounOfCodeRowsInBlock(lastChildAfterIf);
        if (linesOfCodeInElseBlock > 0) {
            result = linesOfCodeInIfBlock / linesOfCodeInElseBlock < this.multiplyFactorForElseBlocks;
        }
        return result;
    }

    private static int getAmounOfCodeRowsInBlock(DetailAST detailAST) {
        DetailAST firstBrace = null;
        if (detailAST.getType() == 92) {
            firstBrace = detailAST.getFirstChild();
        } else if (detailAST.getType() == 83) {
            firstBrace = detailAST.getFirstChild().getNextSibling().getNextSibling().getNextSibling();
        }
        DetailAST lastBrace = firstBrace.getLastChild();
        int linesOfCodeInIfBlock = lastBrace.getLineNo() - firstBrace.getLineNo();
        if (lastBrace.getLineNo() != lastBrace.getParent().getLineNo()) {
            --linesOfCodeInIfBlock;
        }
        return linesOfCodeInIfBlock;
    }

    private static boolean isConditionAllNegative(DetailAST literalIf) {
        int countOfLor;
        int countOfLand;
        int countOfComparisonOperators;
        int countOfNotequal;
        boolean result = false;
        DetailAST ifExpr = literalIf.getFirstChild().getNextSibling();
        int countOfLnot = ConfusingConditionCheck.getCountOfToken(ifExpr, 132);
        int countOfNegativeSymbolInIf = countOfLnot + (countOfNotequal = ConfusingConditionCheck.getCountOfToken(ifExpr, 115));
        if (countOfNegativeSymbolInIf > 0 && countOfNegativeSymbolInIf - (countOfComparisonOperators = (countOfLand = ConfusingConditionCheck.getCountOfToken(ifExpr, 111)) + (countOfLor = ConfusingConditionCheck.getCountOfToken(ifExpr, 110))) == 1) {
            result = true;
        }
        return result;
    }

    private static boolean isIfWithNull(DetailAST literalIf) {
        return literalIf.getFirstChild().getNextSibling().branchContains(135);
    }

    private static int getCountOfToken(DetailAST detAst, int type) {
        int count = 0;
        if (detAst.branchContains(type)) {
            while (detAst != null) {
                count += detAst.getChildCount(type);
                DetailAST detAstChild = detAst.getFirstChild();
                if (detAstChild != null) {
                    count += ConfusingConditionCheck.getCountOfToken(detAstChild, type);
                }
                detAst = detAst.getNextSibling();
            }
        }
        return count;
    }
}

