/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.dialogs.NewPropertyDialog;
import net.sourceforge.pmd.eclipse.ui.preferences.br.EditorFactory;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleSelection;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import net.sourceforge.pmd.eclipse.ui.preferences.panelmanagers.Configuration;
import net.sourceforge.pmd.eclipse.util.ResourceManager;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.lang.rule.XPathRule;
import net.sourceforge.pmd.lang.rule.properties.factories.PropertyDescriptorUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class FormArranger
implements ValueChangeListener {
    private final Composite parent;
    private final Map<Class<?>, EditorFactory> editorFactoriesByValueType;
    private final ValueChangeListener changeListener;
    private final SizeChangeListener sizeChangeListener;
    private PropertySource propertySource;
    private Control[][] widgets;
    private Map<PropertyDescriptor<?>, Control[]> controlsByProperty;

    public static ValueChangeListener chain(final ValueChangeListener primaryListener, final ValueChangeListener secondaryListener) {
        return new ValueChangeListener(){

            @Override
            public void changed(RuleSelection rule, PropertyDescriptor<?> desc, Object newValue) {
                primaryListener.changed(rule, desc, newValue);
                secondaryListener.changed(rule, desc, newValue);
            }

            @Override
            public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
                primaryListener.changed(source, desc, newValue);
                secondaryListener.changed(source, desc, newValue);
            }
        };
    }

    public FormArranger(Composite theParent, Map<Class<?>, EditorFactory> factories, ValueChangeListener listener, SizeChangeListener sizeListener) {
        this.parent = theParent;
        this.editorFactoriesByValueType = factories;
        this.changeListener = FormArranger.chain(listener, this);
        this.sizeChangeListener = sizeListener;
        this.controlsByProperty = new HashMap();
    }

    protected void register(PropertyDescriptor<?> property, Control[] controls) {
        this.controlsByProperty.put(property, controls);
    }

    private EditorFactory factoryFor(PropertyDescriptor<?> desc) {
        return this.editorFactoriesByValueType.get(desc.type());
    }

    public void clearChildren() {
        Control[] kids;
        Control[] controlArray = kids = this.parent.getChildren();
        int n = kids.length;
        int n2 = 0;
        while (n2 < n) {
            Control kid = controlArray[n2];
            kid.dispose();
            ++n2;
        }
        this.parent.pack();
        this.propertySource = null;
    }

    public int arrangeFor(PropertySource theSource) {
        if (this.propertySource == theSource) {
            return -1;
        }
        return this.rearrangeFor(theSource);
    }

    public void loadValues() {
        this.rearrangeFor(this.propertySource);
    }

    private int rearrangeFor(PropertySource theSource) {
        this.clearChildren();
        this.propertySource = theSource;
        if (this.propertySource == null) {
            return -1;
        }
        Map<PropertyDescriptor<?>, Object> valuesByDescriptor = Configuration.filteredPropertiesOf(this.propertySource);
        if (valuesByDescriptor.isEmpty()) {
            if (RuleUtil.isXPathRule(this.propertySource)) {
                this.addAddButton();
                this.parent.pack();
                return 1;
            }
            return 0;
        }
        PropertyDescriptor[] orderedDescs = valuesByDescriptor.keySet().toArray(new PropertyDescriptor[valuesByDescriptor.size()]);
        Arrays.sort(orderedDescs, PropertyDescriptorUtil.COMPARATOR_BY_ORDER);
        int rowCount = 0;
        PropertyDescriptor[] propertyDescriptorArray = orderedDescs;
        int n = orderedDescs.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyDescriptor desc = propertyDescriptorArray[n2];
            EditorFactory factory = this.factoryFor(desc);
            if (factory == null) {
                System.out.println("No editor defined for: " + desc.getClass().getSimpleName());
            } else {
                ++rowCount;
            }
            ++n2;
        }
        boolean isXPathRule = RuleUtil.isXPathRule(this.propertySource);
        int columnCount = isXPathRule ? 3 : 2;
        GridLayout layout = new GridLayout(columnCount, false);
        layout.verticalSpacing = 2;
        layout.marginTop = 1;
        this.parent.setLayout((Layout)layout);
        this.widgets = new Control[rowCount][columnCount];
        int rowsAdded = 0;
        PropertyDescriptor[] propertyDescriptorArray2 = orderedDescs;
        int n3 = orderedDescs.length;
        int n4 = 0;
        while (n4 < n3) {
            PropertyDescriptor desc = propertyDescriptorArray2[n4];
            if (this.addRowWidgets(this.factoryFor(desc), rowsAdded, desc, isXPathRule)) {
                ++rowsAdded;
            }
            ++n4;
        }
        if (RuleUtil.isXPathRule(this.propertySource)) {
            this.addAddButton();
            ++rowsAdded;
        }
        if (rowsAdded > 0) {
            this.parent.pack();
        }
        this.adjustEnabledStates();
        return rowsAdded;
    }

    private void addAddButton() {
        Button button = new Button(this.parent, 8);
        button.setText("Add new...");
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                NewPropertyDialog dialog = new NewPropertyDialog(FormArranger.this.parent.getShell(), FormArranger.this.editorFactoriesByValueType, FormArranger.this.propertySource, FormArranger.this.changeListener);
                if (dialog.open() == 0) {
                    PropertyDescriptor<?> desc = dialog.descriptor();
                    FormArranger.this.propertySource.definePropertyDescriptor(desc);
                    FormArranger.this.rearrangeFor(FormArranger.this.propertySource);
                }
            }
        });
    }

    private boolean addRowWidgets(EditorFactory factory, int rowIndex, PropertyDescriptor<?> desc, boolean isXPathRule) {
        if (factory == null) {
            return false;
        }
        this.widgets[rowIndex][0] = factory.addLabel(this.parent, desc);
        this.widgets[rowIndex][1] = factory.newEditorOn(this.parent, desc, this.propertySource, this.changeListener, this.sizeChangeListener);
        if (isXPathRule) {
            this.widgets[rowIndex][2] = this.addDeleteButton(this.parent, desc, this.propertySource, this.sizeChangeListener);
        }
        this.register(desc, this.widgets[rowIndex]);
        return true;
    }

    private Control addDeleteButton(Composite parent, PropertyDescriptor<?> desc, final PropertySource source, SizeChangeListener sizeChangeListener) {
        Button button = new Button(parent, 8);
        button.setData((Object)desc.name());
        button.setImage(ResourceManager.imageFor("icons/delete.gif"));
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FormArranger.this.rearrangeFor(source);
                FormArranger.this.updateDeleteButtons();
            }
        });
        return button;
    }

    public List<String> updateDeleteButtons() {
        if (this.propertySource == null || !RuleUtil.isXPathRule(this.propertySource)) {
            return Collections.emptyList();
        }
        String source = (String)this.propertySource.getProperty((PropertyDescriptor)XPathRule.XPATH_DESCRIPTOR);
        List<int[]> refPositions = Util.referencedNamePositionsIn(source, '$');
        if (refPositions.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> unreferencedOnes = new ArrayList<String>(refPositions.size());
        List<String> varNames = Util.fragmentsWithin(source, refPositions);
        Control[][] controlArray = this.widgets;
        int n = this.widgets.length;
        int n2 = 0;
        while (n2 < n) {
            Button butt;
            Control[] widgetRow = controlArray[n2];
            String buttonName = (String)(butt = (Button)widgetRow[2]).getData();
            boolean isReferenced = varNames.contains(buttonName);
            butt.setToolTipText(isReferenced ? "Delete variable: $" + buttonName : "Delete unreferenced variable: $" + buttonName);
            if (!isReferenced) {
                unreferencedOnes.add((String)butt.getData());
            }
            ++n2;
        }
        return unreferencedOnes;
    }

    private void adjustEnabledStates() {
        Set ignoreds = this.propertySource.ignoredProperties();
        for (Map.Entry<PropertyDescriptor<?>, Control[]> entry : this.controlsByProperty.entrySet()) {
            if (ignoreds.contains(entry.getKey())) {
                SWTUtil.setEnabled(entry.getValue(), false);
                continue;
            }
            SWTUtil.setEnabled(entry.getValue(), true);
        }
    }

    @Override
    public void changed(RuleSelection rule, PropertyDescriptor<?> desc, Object newValue) {
    }

    @Override
    public void changed(PropertySource source, PropertyDescriptor<?> desc, Object newValue) {
        this.adjustEnabledStates();
    }
}

