/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences.editors;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.PropertySource;
import net.sourceforge.pmd.eclipse.ui.preferences.br.SizeChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.br.ValueChangeListener;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.AbstractEditorFactory;
import net.sourceforge.pmd.eclipse.util.Util;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractMultiValueEditorFactory
extends AbstractEditorFactory {
    protected static final String delimiter = ",";
    private static final int WidgetsPerRow = 3;

    protected AbstractMultiValueEditorFactory() {
    }

    protected abstract void configure(Text var1, PropertyDescriptor<?> var2, PropertySource var3, ValueChangeListener var4);

    protected abstract void setValue(Control var1, Object var2);

    protected abstract void update(PropertySource var1, PropertyDescriptor<?> var2, List<Object> var3);

    protected abstract Object addValueIn(Control var1, PropertyDescriptor<?> var2, PropertySource var3);

    protected abstract Control addWidget(Composite var1, Object var2, PropertyDescriptor<?> var3, PropertySource var4);

    @Override
    public Control newEditorOn(final Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final ValueChangeListener changeListener, final SizeChangeListener sizeListener) {
        final Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        final Text textWidget = new Text(panel, 2052);
        Button butt = new Button(panel, 8);
        butt.setText("...");
        butt.addListener(13, new Listener(){
            boolean itemsVisible = false;
            List<Control> items = new ArrayList<Control>();

            public void handleEvent(Event event) {
                if (this.itemsVisible) {
                    AbstractMultiValueEditorFactory.this.hideCollection(this.items);
                    sizeListener.addedRows(this.items.size() / -3);
                } else {
                    this.items = AbstractMultiValueEditorFactory.this.openCollection(panel, desc, source, textWidget, changeListener, sizeListener);
                    sizeListener.addedRows(this.items.size() / 3);
                }
                this.itemsVisible = !this.itemsVisible;
                textWidget.setEditable(!this.itemsVisible);
                parent.layout();
            }
        });
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        textWidget.setLayoutData((Object)data);
        panel.setLayoutData((Object)new GridData(768));
        this.fillWidget(textWidget, desc, source);
        this.configure(textWidget, desc, source, changeListener);
        return panel;
    }

    private void hideCollection(List<Control> controls) {
        for (Control control : controls) {
            control.dispose();
        }
    }

    private void delete(Control number, Control widget, Control button, List<Control> controlList, Object deleteValue, PropertyDescriptor<?> desc, PropertySource source) {
        controlList.remove(number);
        number.dispose();
        controlList.remove(widget);
        widget.dispose();
        controlList.remove(button);
        button.dispose();
        AbstractMultiValueEditorFactory.renumberLabelsIn(controlList);
        Object[] values = (Object[])this.valueFor(source, desc);
        ArrayList<Object> newValues = new ArrayList<Object>(values.length - 1);
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (!value.equals(deleteValue)) {
                newValues.add(value);
            }
            ++n2;
        }
        this.update(source, desc, newValues);
    }

    private List<Control> openCollection(final Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final Text textWidget, final ValueChangeListener changeListener, final SizeChangeListener sizeListener) {
        final ArrayList<Control> newControls = new ArrayList<Control>();
        int i = 0;
        Object[] values = (Object[])this.valueFor(source, desc);
        i = 0;
        while (i < values.length) {
            final Label number = new Label(parent, 0);
            number.setText(Integer.toString(i + 1));
            final Control widget = this.addWidget(parent, values[i], desc, source);
            widget.setLayoutData((Object)new GridData(768));
            widget.setEnabled(false);
            final Button butt = new Button(parent, 8);
            butt.setText("-");
            final Object value = values[i];
            butt.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    AbstractMultiValueEditorFactory.this.delete((Control)number, widget, (Control)butt, newControls, value, desc, source);
                    AbstractMultiValueEditorFactory.this.fillWidget(textWidget, desc, source);
                    sizeListener.addedRows(-1);
                    changeListener.changed(source, desc, null);
                    parent.getParent().layout();
                }
            });
            newControls.add((Control)number);
            newControls.add(widget);
            newControls.add((Control)butt);
            ++i;
        }
        this.addNewValueRow(parent, desc, source, textWidget, changeListener, sizeListener, newControls, i);
        return newControls;
    }

    protected boolean canAddNewRowFor(PropertyDescriptor<?> desc, PropertySource source) {
        return true;
    }

    private void addNewValueRow(final Composite parent, final PropertyDescriptor<?> desc, final PropertySource source, final Text parentWidget, final ValueChangeListener changeListener, final SizeChangeListener sizeListener, final List<Control> newControls, int i) {
        if (!this.canAddNewRowFor(desc, source)) {
            return;
        }
        final Label number = new Label(parent, 0);
        number.setText(Integer.toString(i + 1));
        newControls.add((Control)number);
        final Control widget = this.addWidget(parent, null, desc, source);
        widget.setLayoutData((Object)new GridData(768));
        newControls.add(widget);
        final Button butt = new Button(parent, 8);
        butt.setText("+");
        newControls.add((Control)butt);
        Listener addListener = new Listener(){

            public void handleEvent(Event event) {
                Object newValue = AbstractMultiValueEditorFactory.this.addValueIn(widget, desc, source);
                if (newValue == null) {
                    return;
                }
                AbstractMultiValueEditorFactory.this.addNewValueRow(parent, desc, source, parentWidget, changeListener, sizeListener, newControls, -1);
                AbstractMultiValueEditorFactory.this.convertToDelete(butt, newValue, parent, newControls, desc, source, parentWidget, number, widget, changeListener, sizeListener);
                widget.setEnabled(false);
                AbstractMultiValueEditorFactory.this.setValue(widget, newValue);
                AbstractMultiValueEditorFactory.renumberLabelsIn(newControls);
                AbstractMultiValueEditorFactory.this.fillWidget(parentWidget, desc, source);
                AbstractMultiValueEditorFactory.this.adjustRendering(source, desc, (Control)parentWidget);
                sizeListener.addedRows(1);
                changeListener.changed(source, desc, newValue);
                parent.getParent().layout();
            }
        };
        butt.addListener(13, addListener);
        widget.addListener(14, addListener);
        widget.setFocus();
    }

    private void convertToDelete(final Button button, final Object toDeleteValue, final Composite parent, final List<Control> newControls, final PropertyDescriptor<?> desc, final PropertySource source, final Text parentWidget, final Label number, final Control widget, final ValueChangeListener changeListener, final SizeChangeListener sizeListener) {
        button.setText("-");
        Util.removeListeners((Control)button, 13);
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                AbstractMultiValueEditorFactory.this.delete((Control)number, widget, (Control)button, newControls, toDeleteValue, desc, source);
                AbstractMultiValueEditorFactory.this.fillWidget(parentWidget, desc, source);
                sizeListener.addedRows(-1);
                changeListener.changed(source, desc, null);
                parent.getParent().layout();
            }
        });
    }

    private static void renumberLabelsIn(List<Control> controls) {
        int i = 1;
        for (Control control : controls) {
            if (!(control instanceof Label)) continue;
            ((Label)control).setText(Integer.toString(i++));
        }
    }

    protected void fillWidget(Text textWidget, PropertyDescriptor<?> desc, PropertySource source) {
        Object[] values = (Object[])this.valueFor(source, desc);
        textWidget.setText(values == null ? "" : StringUtil.asString((Object[])values, (String)", "));
        this.adjustRendering(source, desc, (Control)textWidget);
    }

    protected String[] textWidgetValues(Text textWidget) {
        String values = textWidget.getText().trim();
        if (StringUtil.isEmpty((String)values)) {
            return StringUtil.EMPTY_STRINGS;
        }
        String[] valueSet = values.split(delimiter);
        ArrayList<String> valueList = new ArrayList<String>(valueSet.length);
        String[] stringArray = valueSet;
        int n = valueSet.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            String str = value.trim();
            if (str.length() > 0) {
                valueList.add(str);
            }
            ++n2;
        }
        return valueList.toArray(new String[valueList.size()]);
    }
}

