/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.pmd.util.StringUtil;

public class StringArranger {
    private String indentString;
    private static final char CR = '\n';

    public StringArranger(String theIndent) {
        this.indentString = theIndent;
    }

    public String withIndent(String rawText) {
        return String.valueOf(this.indentString) + rawText;
    }

    public StringBuilder format(String rawText) {
        StringBuilder sb = new StringBuilder();
        for (String line : this.trimmedLinesIn(rawText)) {
            sb.append(this.indentString);
            sb.append(line).append('\n');
        }
        return sb;
    }

    public List<String> trimmedLinesIn(String text) {
        String[] lines = text.split("\n");
        if (lines.length < 1) {
            return Collections.emptyList();
        }
        ArrayList<String> lineSet = new ArrayList<String>(lines.length);
        int startLine = 0;
        while (startLine < lines.length && StringUtil.isEmpty((String)lines[startLine])) {
            ++startLine;
        }
        int endLine = lines.length - 1;
        while (endLine >= 0 && StringUtil.isEmpty((String)lines[endLine])) {
            --endLine;
        }
        int i = startLine;
        while (i <= endLine) {
            lineSet.add(lines[i].trim());
            ++i;
        }
        return lineSet;
    }
}

