/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.preferences.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleColumnDescriptor;
import net.sourceforge.pmd.eclipse.ui.preferences.br.RuleTableColumns;
import net.sourceforge.pmd.eclipse.ui.preferences.editors.SWTUtil;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.PreferenceStore;

public class PreferenceUIStore {
    private PreferenceStore preferenceStore;
    private static final String tableFraction = "net.sourceforge.pmd.eclipse.plugin.ruletable.fraction";
    private static final String tableHiddenCols = "net.sourceforge.pmd.eclipse.plugin.ruletable.hiddenColumns";
    private static final String tableColumnSortUp = "net.sourceforge.pmd.eclipse.plugin.ruletable.sortUp";
    private static final String groupingColumn = "net.sourceforge.pmd.eclipse.plugin.ruletable.groupingColumn";
    private static final String selectedRuleNames = "net.sourceforge.pmd.eclipse.plugin.ruletable.selectedRules";
    private static final String selectedPropertyTab = "net.sourceforge.pmd.eclipse.plugin.ruletable.selectedPropertyTab";
    private static final String globalRuleManagement = "net.sourceforge.pmd.eclipse.plugin.globalRuleManagement";
    private static final int tableFractionDefault = 55;
    private static final char stringSeparator = ',';
    private static final RuleColumnDescriptor[] defaultHiddenColumns = new RuleColumnDescriptor[]{RuleTableColumns.externalURL, RuleTableColumns.minLangVers, RuleTableColumns.fixCount, RuleTableColumns.exampleCount, RuleTableColumns.maxLangVers, RuleTableColumns.since, RuleTableColumns.modCount};
    private static final boolean defaultSortUp = false;
    public static final PreferenceUIStore instance = new PreferenceUIStore();

    private static String defaultHiddenColumnIds() {
        HashSet<String> colNames = new HashSet<String>(defaultHiddenColumns.length);
        RuleColumnDescriptor[] ruleColumnDescriptorArray = defaultHiddenColumns;
        int n = defaultHiddenColumns.length;
        int n2 = 0;
        while (n2 < n) {
            RuleColumnDescriptor rcDesc = ruleColumnDescriptorArray[n2];
            colNames.add(rcDesc.id());
            ++n2;
        }
        return SWTUtil.asString(colNames, ',');
    }

    private PreferenceUIStore() {
        this.initialize();
    }

    private void initialize() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath path = root.getLocation();
        String fileName = path.append("/.metadata/.plugins/org.eclipse.core.runtime/.settings/net.sourceforge.pmd.eclipse.plugin.prefs").toString();
        this.preferenceStore = new PreferenceStore(fileName);
        this.preferenceStore.setDefault(globalRuleManagement, false);
        try {
            this.preferenceStore.load();
        }
        catch (IOException iOException) {
            this.createNewStore();
        }
    }

    private void createNewStore() {
        this.preferenceStore.setValue(tableFraction, 55);
        this.preferenceStore.setValue(tableHiddenCols, PreferenceUIStore.defaultHiddenColumnIds());
        this.preferenceStore.setValue(tableColumnSortUp, false);
        this.preferenceStore.setValue(groupingColumn, "");
        this.preferenceStore.setValue(selectedRuleNames, "");
        this.preferenceStore.setValue(selectedPropertyTab, 0);
        this.preferenceStore.setValue(globalRuleManagement, false);
        this.save();
    }

    public void save() {
        try {
            this.preferenceStore.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int tableFraction() {
        return this.preferenceStore.getInt(tableFraction);
    }

    public void tableFraction(int aFraction) {
        this.preferenceStore.setValue(tableFraction, aFraction);
    }

    public Set<String> hiddenColumnIds() {
        String names = this.preferenceStore.getString(tableHiddenCols);
        return SWTUtil.asStringSet(names, ',');
    }

    public void hiddenColumnIds(Set<String> names) {
        String nameStr = SWTUtil.asString(names, ',');
        this.preferenceStore.setValue(tableHiddenCols, nameStr);
    }

    public int selectedPropertyTab() {
        return this.preferenceStore.getInt(selectedPropertyTab);
    }

    public void selectedPropertyTab(int anIndex) {
        this.preferenceStore.setValue(selectedPropertyTab, anIndex);
    }

    public boolean globalRuleManagement() {
        return this.preferenceStore.getBoolean(globalRuleManagement);
    }

    public void globalRuleManagement(boolean b) {
        this.preferenceStore.setValue(globalRuleManagement, b);
    }

    public Set<String> selectedRuleNames() {
        String names = this.preferenceStore.getString(selectedRuleNames);
        return SWTUtil.asStringSet(names, ',');
    }

    public void selectedRuleNames(Collection<String> ruleNames) {
        String nameStr = SWTUtil.asString(ruleNames, ',');
        this.preferenceStore.setValue(selectedRuleNames, nameStr);
    }

    public boolean sortDirectionUp() {
        return this.preferenceStore.getBoolean(tableColumnSortUp);
    }

    public void sortDirectionUp(boolean isUp) {
        this.preferenceStore.setValue(tableColumnSortUp, isUp);
    }

    public String groupingColumnName() {
        return this.preferenceStore.getString(groupingColumn);
    }

    public void groupingColumnName(String columnName) {
        this.preferenceStore.setValue(groupingColumn, columnName);
    }
}

