/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.builder;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.PMDRuntimeConstants;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import net.sourceforge.pmd.util.StringUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;

public class MarkerUtil {
    public static final IMarker[] EMPTY_MARKERS = new IMarker[0];
    private static Map<String, Rule> rulesByName;

    private MarkerUtil() {
    }

    public static boolean hasAnyRuleMarkers(IResource resource) throws CoreException {
        final boolean[] foundOne = new boolean[1];
        IResourceVisitor ruleMarkerFinder = new IResourceVisitor(){

            public boolean visit(IResource resource) {
                if (foundOne[0]) {
                    return false;
                }
                if (resource instanceof IFile) {
                    String[] stringArray = PMDRuntimeConstants.RULE_MARKER_TYPES;
                    int n = PMDRuntimeConstants.RULE_MARKER_TYPES.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String markerType = stringArray[n2];
                        IMarker[] ruleMarkers = null;
                        try {
                            ruleMarkers = resource.findMarkers(markerType, true, 2);
                        }
                        catch (CoreException coreException) {}
                        if (ruleMarkers != null && ruleMarkers.length > 0) {
                            foundOne[0] = true;
                            return false;
                        }
                        ++n2;
                    }
                }
                return true;
            }
        };
        try {
            resource.accept(ruleMarkerFinder);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return foundOne[0];
    }

    private static IProject projectFor(IResource resource) {
        if (resource instanceof IWorkspaceRoot) {
            return null;
        }
        if (resource instanceof IProject) {
            return (IProject)resource;
        }
        return MarkerUtil.projectFor((IResource)resource.getParent());
    }

    public static Set<IProject> commonProjectsOf(IMarker[] markers) {
        HashSet<IProject> projects = new HashSet<IProject>();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            IProject project = MarkerUtil.projectFor(marker.getResource());
            if (project != null) {
                projects.add(project);
            }
            ++n2;
        }
        return projects;
    }

    public static String ruleNameFor(IMarker marker) {
        return marker.getAttribute("rulename", "");
    }

    public static int rulePriorityFor(IMarker marker) throws CoreException {
        return (Integer)marker.getAttribute("pmd_priority");
    }

    public static String messageFor(IMarker marker, String defaultValue) {
        return marker.getAttribute("message", defaultValue);
    }

    public static Long createdOn(IMarker marker, long onErrorValue) {
        try {
            return marker.getCreationTime();
        }
        catch (CoreException coreException) {
            return onErrorValue;
        }
    }

    public static int rulePriorityFor(IMarker marker, int defaultValue) {
        return marker.getAttribute("pmd_priority", defaultValue);
    }

    public static boolean doneState(IMarker marker, boolean defaultValue) {
        return marker.getAttribute("done", defaultValue);
    }

    public static int deleteViolationsOf(String ruleName, IResource resource) {
        IMarker[] markers;
        block5: {
            markers = MarkerUtil.findAllMarkers(resource);
            if (markers.length != 0) break block5;
            return 0;
        }
        try {
            ArrayList<IMarker> matches = new ArrayList<IMarker>(markers.length);
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String name = MarkerUtil.ruleNameFor(marker);
                if (ruleName.equals(name)) {
                    matches.add(marker);
                }
                ++n2;
            }
            markers = new IMarker[matches.size()];
            matches.toArray(markers);
            resource.getWorkspace().deleteMarkers(markers);
            return markers.length;
        }
        catch (CoreException coreException) {
            return 0;
        }
    }

    public static List<IMarkerDelta> markerDeltasIn(IResourceChangeEvent event) {
        ArrayList<IMarkerDelta> deltas = new ArrayList<IMarkerDelta>();
        String[] stringArray = PMDRuntimeConstants.RULE_MARKER_TYPES;
        int n = PMDRuntimeConstants.RULE_MARKER_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta[] deltaArray;
            String markerType = stringArray[n2];
            IMarkerDelta[] iMarkerDeltaArray = deltaArray = event.findMarkerDeltas(markerType, true);
            int n3 = deltaArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMarkerDelta delta = iMarkerDeltaArray[n4];
                deltas.add(delta);
                ++n4;
            }
            ++n2;
        }
        return deltas;
    }

    public static List<Rule> rulesFor(IMarker[] markers) {
        ArrayList<Rule> rules = new ArrayList<Rule>(markers.length);
        RuleSet ruleset = PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            Rule rule;
            IMarker marker = iMarkerArray[n2];
            String name = MarkerUtil.ruleNameFor(marker);
            if (!StringUtil.isEmpty((String)name) && (rule = ruleset.getRuleByName(name)) != null) {
                rules.add(rule);
            }
            ++n2;
        }
        return rules;
    }

    public static String commonRuleNameAmong(IMarker[] markers) {
        String ruleName = MarkerUtil.ruleNameFor(markers[0]);
        int i = 1;
        while (i < markers.length) {
            if (!ruleName.equals(MarkerUtil.ruleNameFor(markers[i]))) {
                return null;
            }
            ++i;
        }
        return ruleName;
    }

    public static void deleteAllMarkersIn(IResource resource) throws CoreException {
        MarkerUtil.deleteMarkersIn(resource, PMDRuntimeConstants.ALL_MARKER_TYPES);
    }

    public static void deleteMarkersIn(IResource resource, String markerType) throws CoreException {
        MarkerUtil.deleteMarkersIn(resource, new String[]{markerType});
    }

    public static void deleteMarkersIn(IResource resource, String[] markerTypes) throws CoreException {
        String[] stringArray = markerTypes;
        int n = markerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String markerType = stringArray[n2];
            resource.deleteMarkers(markerType, true, 2);
            ++n2;
        }
        PMDPlugin.getDefault().removedMarkersIn(resource);
    }

    public static IMarker[] findAllMarkers(IResource resource) throws CoreException {
        return MarkerUtil.findMarkers(resource, PMDRuntimeConstants.ALL_MARKER_TYPES);
    }

    public static IMarker[] findMarkers(IResource resource, String markerType) throws CoreException {
        return MarkerUtil.findMarkers(resource, new String[]{markerType});
    }

    public static IMarker[] findMarkers(IResource resource, String[] markerTypes) throws CoreException {
        ArrayList<IMarker> markerList = new ArrayList<IMarker>();
        String[] stringArray = markerTypes;
        int n = markerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String markerType = stringArray[n2];
            IMarker[] iMarkerArray = resource.findMarkers(markerType, true, 2);
            int n3 = iMarkerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMarker marker = iMarkerArray[n4];
                markerList.add(marker);
                ++n4;
            }
            ++n2;
        }
        IMarker[] markerArray = new IMarker[markerList.size()];
        return markerList.toArray(markerArray);
    }

    public static Set<Integer> priorityRangeOf(IResource resource, String[] markerTypes, int sizeLimit) throws CoreException {
        HashSet<Integer> priorityLevels = new HashSet<Integer>(sizeLimit);
        String[] stringArray = markerTypes;
        int n = markerTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String markerType = stringArray[n2];
            IMarker[] iMarkerArray = resource.findMarkers(markerType, true, 2);
            int n3 = iMarkerArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IMarker marker = iMarkerArray[n4];
                priorityLevels.add(MarkerUtil.rulePriorityFor(marker));
                if (priorityLevels.size() == sizeLimit) {
                    return priorityLevels;
                }
                ++n4;
            }
            ++n2;
        }
        return priorityLevels;
    }

    public static Set<String> currentRuleNames() {
        MarkerUtil.gatherRuleNames();
        return rulesByName.keySet();
    }

    private static void gatherRuleNames() {
        rulesByName = new HashMap<String, Rule>();
        Set<RuleSet> ruleSets = PMDPlugin.getDefault().getRuleSetManager().getRegisteredRuleSets();
        for (RuleSet rs : ruleSets) {
            for (Rule rule : rs.getRules()) {
                rulesByName.put(rule.getName(), rule);
            }
        }
    }

    private static Rule ruleFrom(IMarker marker) {
        String ruleName = marker.getAttribute("rulename", "");
        if (StringUtil.isEmpty((String)ruleName)) {
            return null;
        }
        return rulesByName.get(ruleName);
    }

    public static Set<IFile> allMarkedFiles(RootRecord root) {
        MarkerUtil.gatherRuleNames();
        HashSet<IFile> files = new HashSet<IFile>();
        AbstractPMDRecord[] abstractPMDRecordArray = root.getChildren();
        int n = abstractPMDRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractPMDRecord projectRecord = abstractPMDRecordArray[n2];
            AbstractPMDRecord[] abstractPMDRecordArray2 = projectRecord.getChildren();
            int n3 = abstractPMDRecordArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                AbstractPMDRecord packageRecord = abstractPMDRecordArray2[n4];
                AbstractPMDRecord[] abstractPMDRecordArray3 = packageRecord.getChildren();
                int n5 = abstractPMDRecordArray3.length;
                int n6 = 0;
                while (n6 < n5) {
                    AbstractPMDRecord fileRecord = abstractPMDRecordArray3[n6];
                    ((FileRecord)fileRecord).updateChildren();
                    AbstractPMDRecord[] abstractPMDRecordArray4 = fileRecord.getChildren();
                    int n7 = abstractPMDRecordArray4.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        AbstractPMDRecord mRecord = abstractPMDRecordArray4[n8];
                        MarkerRecord markerRecord = (MarkerRecord)mRecord;
                        IMarker[] iMarkerArray = markerRecord.findMarkers();
                        int n9 = iMarkerArray.length;
                        int n10 = 0;
                        while (n10 < n9) {
                            IMarker marker = iMarkerArray[n10];
                            Rule rule = MarkerUtil.ruleFrom(marker);
                            if (rule != null) {
                                files.add((IFile)fileRecord.getResource());
                                break;
                            }
                            ++n10;
                        }
                        ++n8;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
        return files;
    }
}

