/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.IDialogValidator;

public class InputAttributeEditorDialog
extends TitleAreaDialog
implements IDialogValidator {
    private IInputAttribute property;
    private Label nameLabel;
    private Text nameText;
    private Label requiredLabel;
    private Combo requiredText;
    private Label scopeLabel;
    private Combo scopeText;
    private Button okButton;
    private Label valueLabel;
    private Text valueText;
    private Label typeLabel;
    private Text typeText;

    public InputAttributeEditorDialog(Shell parentShell, IInputAttribute state) {
        super(parentShell);
        this.property = state;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.property.setName(this.trimString(this.nameText.getText()));
            if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.property)) {
                if (this.trimString(this.requiredText.getText()) != null) {
                    this.property.setRequired(Boolean.valueOf(this.trimString(this.requiredText.getText())).booleanValue());
                }
                this.property.setScope(this.trimString(this.scopeText.getText()));
            } else {
                this.property.setType(this.trimString(this.typeText.getText()));
                this.property.setValue(this.trimString(this.valueText.getText()));
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
        shell.setImage(this.getImage());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.nameText.setFocus();
        if (this.property != null && this.property.getName() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
        this.validateInput();
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite nameGroup = new Composite(composite, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        this.nameLabel = new Label(nameGroup, 0);
        this.nameLabel.setText("Name");
        this.nameText = new Text(nameGroup, 2052);
        if (this.property != null && this.property.getName() != null) {
            this.nameText.setText(this.property.getName());
        }
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputAttributeEditorDialog.this.validateInput();
            }
        });
        this.requiredLabel = new Label(nameGroup, 0);
        this.requiredLabel.setText("Required");
        this.requiredText = new Combo(nameGroup, 12);
        this.requiredText.setItems(new String[]{"", "true", "false"});
        if (this.property != null) {
            this.requiredText.setText(Boolean.toString(this.property.getRequired()));
        }
        this.requiredText.setLayoutData((Object)new GridData(768));
        this.requiredText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InputAttributeEditorDialog.this.validateInput();
            }
        });
        if (WebflowModelXmlUtils.isVersion1Flow((IWebflowModelElement)this.property)) {
            this.scopeLabel = new Label(nameGroup, 0);
            this.scopeLabel.setText("Scope");
            this.scopeText = new Combo(nameGroup, 12);
            this.scopeText.setItems(new String[]{"", "request", "flash", "flow", "conversation", "default"});
            if (this.property != null && this.property.getScope() != null) {
                this.scopeText.setText(this.property.getScope());
            }
            this.scopeText.setLayoutData((Object)new GridData(768));
            this.scopeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputAttributeEditorDialog.this.validateInput();
                }
            });
        } else {
            this.valueLabel = new Label(nameGroup, 0);
            this.valueLabel.setText("Value");
            this.valueText = new Text(nameGroup, 2052);
            if (this.property != null && this.property.getValue() != null) {
                this.valueText.setText(this.property.getValue());
            }
            this.valueText.setLayoutData((Object)new GridData(768));
            this.valueText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputAttributeEditorDialog.this.validateInput();
                }
            });
            this.typeLabel = new Label(nameGroup, 0);
            this.typeLabel.setText("Type");
            this.typeText = new Text(nameGroup, 2052);
            if (this.property != null && this.property.getType() != null) {
                this.typeText.setText(this.property.getType());
            }
            this.typeText.setLayoutData((Object)new GridData(768));
            this.typeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InputAttributeEditorDialog.this.validateInput();
                }
            });
        }
        InputAttributeEditorDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    public String getId() {
        return this.nameText.getText();
    }

    protected Image getImage() {
        return WebflowUIImages.getImage((String)"org.springframework.ide.eclipse.webflow.ui.editor.properties_obj.gif");
    }

    public String getMessage() {
        return "Enter the details for the property";
    }

    protected String getShellTitle() {
        return "Property";
    }

    protected String getTitle() {
        return "Property properties";
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    @Override
    public void validateInput() {
        String id = this.nameText.getText();
        boolean error = false;
        StringBuffer errorMessage = new StringBuffer();
        if (id == null || "".equals(id)) {
            errorMessage.append("A valid name is required. ");
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage.toString());
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

