/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.actions;

import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.ui.IWorkbenchPart;
import org.springframework.ide.eclipse.webflow.core.model.IEndState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;
import org.springframework.ide.eclipse.webflow.ui.graph.parts.FlowPart;

public class SetAsStartStateAction
extends SelectionAction {
    public static final String STARTSTATE_REQUEST = "Start_state";
    public static final String STARTSTATE = "Start_state";
    Request request = new Request((Object)"Start_state");

    public SetAsStartStateAction(IWorkbenchPart part) {
        super(part);
        this.setText("Start state");
        this.setId("Start_state");
        this.setToolTipText("Set selected state as start state");
        this.setImageDescriptor(WebflowUIImages.DESC_OBJS_START_STATE);
        this.setHoverImageDescriptor(this.getImageDescriptor());
    }

    protected boolean calculateEnabled() {
        return this.canPerformAction();
    }

    private boolean canPerformAction() {
        if (this.getSelectedObjects().isEmpty()) {
            return false;
        }
        List parts = this.getSelectedObjects();
        int i = 0;
        while (i < parts.size()) {
            IWebflowState parent;
            Object o = parts.get(i);
            if (!(o instanceof EditPart)) {
                return false;
            }
            EditPart part = (EditPart)o;
            if (!(part.getModel() instanceof IState) || part.getModel() instanceof IEndState) {
                return false;
            }
            if (part instanceof FlowPart) {
                return false;
            }
            if (part.getModel() instanceof IState && !(part.getModel() instanceof IWebflowState) && (parent = (IWebflowState)((IState)part.getModel()).getElementParent()).isStartState((IState)part.getModel())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Command getCommand() {
        List editparts = this.getSelectedObjects();
        CompoundCommand cc = new CompoundCommand();
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = (EditPart)editparts.get(i);
            cc.add(part.getCommand(this.request));
            ++i;
        }
        return cc;
    }

    public void run() {
        this.execute(this.getCommand());
    }
}

