/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angularjs.internal.ui.utils;

import java.util.Collection;
import java.util.List;
import org.eclipse.angularjs.internal.ui.ImageResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import tern.angular.AngularType;
import tern.angular.modules.Directive;
import tern.angular.modules.DirectiveParameter;
import tern.eclipse.ide.ui.TernUIPlugin;
import tern.eclipse.ide.ui.utils.HTMLTernPrinter;
import tern.server.protocol.completions.TernCompletionItem;
import tern.utils.StringUtils;

public class HTMLAngularPrinter {
    public static String getAngularInfo(String type, String name, String module, String controller, AngularType angularType, String doc, String origin) {
        StringBuffer buffer = new StringBuffer();
        String title = HTMLAngularPrinter.getTitle(name, module, controller, angularType);
        ImageDescriptor descriptor = HTMLAngularPrinter.getImageDescriptor(angularType);
        HTMLTernPrinter.startPage((StringBuffer)buffer, (String)title, (ImageDescriptor)descriptor);
        HTMLTernPrinter.addDocContent((StringBuffer)buffer, (String)doc);
        HTMLTernPrinter.startDefinitionList((StringBuffer)buffer);
        HTMLTernPrinter.addDefinitionListItem((StringBuffer)buffer, (String)"Signature", (String)type);
        HTMLTernPrinter.addOriginContent((StringBuffer)buffer, (String)origin);
        HTMLTernPrinter.endDefinitionList((StringBuffer)buffer);
        HTMLTernPrinter.endPage((StringBuffer)buffer);
        return buffer.toString();
    }

    private static String getTitle(String name, String module, String controller, AngularType angularType) {
        switch (angularType) {
            case module: {
                return "<b>" + name + "</b>" + " module";
            }
            case controller: {
                StringBuilder title = new StringBuilder("<b>").append(name).append("</b>").append(" controller");
                if (!StringUtils.isEmpty((String)module)) {
                    title.append(" in module <b>").append(module).append("</b>").toString();
                }
                return title.toString();
            }
        }
        return null;
    }

    public static String getDirectiveInfo(Directive directive) {
        StringBuffer buffer = new StringBuffer();
        String title = HTMLAngularPrinter.getTitle(directive);
        ImageDescriptor descriptor = HTMLAngularPrinter.getImageDescriptor(AngularType.directive);
        HTMLTernPrinter.startPage((StringBuffer)buffer, (String)title, (ImageDescriptor)descriptor);
        HTMLTernPrinter.addDocContent((StringBuffer)buffer, (String)directive.getDescription());
        HTMLTernPrinter.startDefinitionList((StringBuffer)buffer);
        HTMLTernPrinter.addDefinitionListItem((StringBuffer)buffer, (String)"restrict", (String)directive.getRestrict());
        HTMLTernPrinter.addDefinitionListItem((StringBuffer)buffer, (String)"tags", (Collection)directive.getTagNames());
        HTMLTernPrinter.addDefinitionListItem((StringBuffer)buffer, (String)"parameters", (Collection)directive.getParameterNames());
        HTMLTernPrinter.endDefinitionList((StringBuffer)buffer);
        HTMLTernPrinter.addURLContent((StringBuffer)buffer, (String)directive.getURL());
        HTMLTernPrinter.endPage((StringBuffer)buffer);
        return buffer.toString();
    }

    private static String getTitle(Directive directive) {
        StringBuilder title = new StringBuilder("");
        title.append("<b>");
        title.append(directive.getName());
        title.append("</b>");
        title.append(" directive in module ");
        title.append("<b>");
        title.append(directive.getModule().getName());
        title.append("</b>");
        return title.toString();
    }

    public static String getDirectiveParameterInfo(DirectiveParameter parameter) {
        StringBuffer buffer = new StringBuffer();
        String title = HTMLAngularPrinter.getTitle(parameter);
        ImageDescriptor descriptor = ImageResource.getImageDescriptor("directive_param");
        HTMLTernPrinter.startPage((StringBuffer)buffer, (String)title, (ImageDescriptor)descriptor);
        HTMLTernPrinter.addDocContent((StringBuffer)buffer, (String)parameter.getDescription());
        HTMLTernPrinter.addURLContent((StringBuffer)buffer, (String)parameter.getDirective().getURL());
        HTMLTernPrinter.endPage((StringBuffer)buffer);
        return buffer.toString();
    }

    private static String getTitle(DirectiveParameter parameter) {
        StringBuilder title = new StringBuilder("");
        title.append("<b>");
        title.append(parameter.getName());
        title.append("</b>");
        title.append(" parameter in directive ");
        title.append("<b>");
        Directive directive = parameter.getDirective();
        title.append(directive.getModule().getName());
        title.append("#");
        title.append(directive.getName());
        title.append("</b>");
        String description = directive.getDescription();
        if (!StringUtils.isEmpty((String)description)) {
            title.append("<br/>");
            title.append("<br/>");
            title.append(description);
        }
        return title.toString();
    }

    public static String getAngularInfo(TernCompletionItem item, Boolean guess, String module, String controller) {
        StringBuffer buffer = new StringBuffer();
        ImageDescriptor descriptor = TernUIPlugin.getTernDescriptorManager().getImageDescriptor(item);
        HTMLTernPrinter.startPage((StringBuffer)buffer, (String)HTMLTernPrinter.getTitle((TernCompletionItem)item), (ImageDescriptor)descriptor);
        HTMLTernPrinter.addDocContent((StringBuffer)buffer, (String)item.getDoc());
        HTMLTernPrinter.startDefinitionList((StringBuffer)buffer);
        HTMLTernPrinter.addDefinitionListItem((StringBuffer)buffer, (String)"Module", (String)module);
        HTMLTernPrinter.addDefinitionListItem((StringBuffer)buffer, (String)"Controller", (String)controller);
        HTMLTernPrinter.addParametersContent((StringBuffer)buffer, (List)item.getParameters());
        HTMLTernPrinter.addReturnTypeContent((StringBuffer)buffer, (String)item.getJsType());
        HTMLTernPrinter.addOriginContent((StringBuffer)buffer, (String)item.getOrigin());
        HTMLTernPrinter.addGuessContent((StringBuffer)buffer, (Boolean)guess);
        HTMLTernPrinter.addURLContent((StringBuffer)buffer, (String)item.getURL());
        HTMLTernPrinter.endDefinitionList((StringBuffer)buffer);
        HTMLTernPrinter.endPage((StringBuffer)buffer);
        return buffer.toString();
    }

    public static Image getImage(AngularType angularType) {
        String imageKey = HTMLAngularPrinter.getImageKey(angularType);
        if (imageKey != null) {
            return ImageResource.getImage(imageKey);
        }
        return null;
    }

    public static ImageDescriptor getImageDescriptor(AngularType angularType) {
        String imageKey = HTMLAngularPrinter.getImageKey(angularType);
        if (imageKey != null) {
            return ImageResource.getImageDescriptor(imageKey);
        }
        return null;
    }

    private static String getImageKey(AngularType angularType) {
        switch (angularType) {
            case module: {
                return "angularjs";
            }
            case controller: {
                return "controller";
            }
            case directive: {
                return "directive";
            }
        }
        return null;
    }
}

