/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core.util;

import java.io.IOException;
import java.io.OutputStream;

public class MultiplexingOutputStream
extends OutputStream {
    OutputStream[] streams = null;

    public MultiplexingOutputStream(OutputStream ... streams) {
        this.streams = streams == null ? new OutputStream[0] : streams;
    }

    @Override
    public void write(int b) throws IOException {
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream s = outputStreamArray[n2];
            s.write(b);
            ++n2;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream s = outputStreamArray[n2];
            s.write(b, off, len);
            ++n2;
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
        Throwable caught = null;
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream s = outputStreamArray[n2];
            try {
                s.close();
            }
            catch (Throwable e) {
                caught = e;
            }
            ++n2;
        }
        if (caught != null) {
            if (caught instanceof IOException) {
                throw (IOException)caught;
            }
            throw (Error)caught;
        }
    }

    @Override
    public void flush() throws IOException {
        OutputStream[] outputStreamArray = this.streams;
        int n = this.streams.length;
        int n2 = 0;
        while (n2 < n) {
            OutputStream s = outputStreamArray[n2];
            s.flush();
            ++n2;
        }
    }
}

