/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.core;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.service.prefs.BackingStoreException;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;

public class ResourceProvider {
    public static final String RECORD_SEPARATOR_PATTERN = "[\\r\\n\\s]";
    public static final String FIELD_SEPARATOR = "|";
    public static final String FIELD_SEPARATOR_PATTERN = "\\|";
    public static final String RECORD_SEPARATOR = "\n";
    private final IEclipsePreferences preferences;
    private static ResourceProvider instance = new ResourceProvider();
    private final Map<String, Property> propertyById;
    private final List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();

    public static ResourceProvider getInstance() {
        return instance;
    }

    public static String getUrl(String key) {
        return ResourceProvider.getUrls(key)[0];
    }

    public static String[] getUrls(String key) {
        String value = instance.getValue(key);
        if (value == null) {
            throw new RuntimeException(NLS.bind((String)"No URL found for key: ''{0}''", (Object)key));
        }
        if (value.isEmpty()) {
            return new String[0];
        }
        if (value.contains("%UUID%")) {
            value = value.replace("%UUID%", CorePlugin.getUUID());
        }
        if (value.contains("%VERSION%") || value.contains("%SHORT_VERSION%")) {
            Bundle bundle = CorePlugin.getDefault().getBundle();
            Version version = new Version((String)bundle.getHeaders().get("Bundle-Version"));
            value = value.replace("%VERSION%", version.toString());
            value = value.replace("%SHORT_VERSION%", String.valueOf(version.getMajor()) + "." + version.getMinor());
        }
        String[] values = value.split(RECORD_SEPARATOR_PATTERN);
        return ResourceProvider.discardLocationNames(values);
    }

    private static String[] discardLocationNames(String[] values) {
        int i = 0;
        while (i < values.length) {
            String nameUrlString = values[i];
            String[] nameUrlStrings = nameUrlString.split(FIELD_SEPARATOR_PATTERN);
            if (nameUrlStrings.length == 2) {
                String url;
                values[i] = url = nameUrlStrings[1];
            }
            ++i;
        }
        return values;
    }

    private ResourceProvider() {
        this.preferences = new InstanceScope().getNode("org.springsource.ide.eclipse.commons.core");
        this.preferences.addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                Property p = (Property)ResourceProvider.this.propertyById.get(event.getKey());
                if (p != null) {
                    for (PropertyChangeListener listener : ResourceProvider.this.listeners) {
                        listener.propertyChange(new PropertyChangeEvent(ResourceProvider.this, p.id, event.getOldValue(), event.getNewValue()));
                    }
                }
            }
        });
        ExtensionPointReader reader = new ExtensionPointReader();
        reader.read(this);
        this.propertyById = reader.propertyById;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.add(listener);
    }

    public IEclipsePreferences getPreferences() {
        return this.preferences;
    }

    public Collection<Property> getProperties() {
        return Collections.unmodifiableCollection(this.propertyById.values());
    }

    public Property getProperty(String id) {
        return this.propertyById.get(id);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners.remove(listener);
    }

    private String getValue(String key) {
        Property p = this.propertyById.get(key);
        return p != null ? p.getValue() : null;
    }

    private static class ExtensionPointReader {
        private static final String ATTRIBUTE_ID = "id";
        private static final String ATTRIBUTE_VALUE = "value";
        private static final String ATTRIBUTE_LABEL = "label";
        private static final String ATTRIBUTE_TYPE = "type";
        private static final String ATTRIBUTE_MULTI_VALUE = "multiValue";
        private static final String ATTRIBUTE_DEFAULT_VALUE = "defaultValue";
        private static final String ATTRIBUTE_USER_CONFIGURABLE = "userConfigurable";
        private static final String ELEMENT_URL = "url";
        private static final String ELEMENT_PROPERTY = "propertyDefinition";
        private static final String EXTENSION_ID_REFERENCES = "com.springsource.sts.core.resources";
        private final Map<String, String> valueByKey = new HashMap<String, String>();
        private final Map<String, Property> propertyById = new HashMap<String, Property>();

        private ExtensionPointReader() {
        }

        public void read(ResourceProvider resourceProvider) {
            IConfigurationElement element;
            int n;
            int n2;
            IConfigurationElement[] iConfigurationElementArray;
            IConfigurationElement[] elements;
            IExtension extension;
            IExtension[] extensions;
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_ID_REFERENCES);
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n3 = extensions.length;
            int n4 = 0;
            while (n4 < n3) {
                extension = iExtensionArray[n4];
                iConfigurationElementArray = elements = extension.getConfigurationElements();
                n2 = elements.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().compareTo(ELEMENT_PROPERTY) == 0) {
                        Property p = new Property(resourceProvider);
                        p.id = element.getAttribute(ATTRIBUTE_ID);
                        p.label = element.getAttribute(ATTRIBUTE_LABEL);
                        p.defaultValue = element.getAttribute(ATTRIBUTE_DEFAULT_VALUE);
                        p.multiValue = Boolean.parseBoolean(element.getAttribute(ATTRIBUTE_MULTI_VALUE));
                        p.userConfigurable = Boolean.parseBoolean(element.getAttribute(ATTRIBUTE_USER_CONFIGURABLE));
                        p.type = element.getAttribute(ATTRIBUTE_TYPE);
                        this.propertyById.put(p.id, p);
                    }
                    ++n;
                }
                ++n4;
            }
            iExtensionArray = extensions;
            n3 = extensions.length;
            n4 = 0;
            while (n4 < n3) {
                extension = iExtensionArray[n4];
                iConfigurationElementArray = elements = extension.getConfigurationElements();
                n2 = elements.length;
                n = 0;
                while (n < n2) {
                    element = iConfigurationElementArray[n];
                    if (element.getName().compareTo(ELEMENT_URL) == 0) {
                        String key = element.getAttribute(ATTRIBUTE_ID);
                        String value = element.getAttribute(ATTRIBUTE_VALUE);
                        this.valueByKey.put(key, value);
                        Property p = this.propertyById.get(key);
                        if (p == null) {
                            p = new Property(resourceProvider);
                            p.id = key;
                            p.label = "";
                            this.propertyById.put(p.id, p);
                        }
                        p.contributedValue = value;
                    }
                    ++n;
                }
                ++n4;
            }
        }
    }

    public static class Property {
        public String type;
        private String id;
        private String label;
        private String defaultValue;
        private boolean multiValue;
        private boolean userConfigurable;
        private String contributedValue;
        private final ResourceProvider provider;

        private Property(ResourceProvider provider) {
            this.provider = provider;
        }

        public String getDefaultValue() {
            String value = this.contributedValue;
            if (value == null) {
                value = this.defaultValue;
            }
            return value;
        }

        public String getLabel() {
            return this.label;
        }

        public String getValue() {
            String value = this.provider.getPreferences().get(this.id, null);
            if (value == null) {
                value = this.contributedValue;
            }
            if (value == null) {
                value = this.defaultValue;
            }
            return value;
        }

        public boolean isMultiValue() {
            return this.multiValue;
        }

        public boolean isUserConfigurable() {
            return this.userConfigurable;
        }

        public void setValue(String value) {
            this.provider.getPreferences().put(this.id, value);
            try {
                this.provider.getPreferences().flush();
            }
            catch (BackingStoreException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", "Error occured while saving preferences", (Throwable)e));
            }
        }
    }
}

