/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.core.metadata.model;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.springframework.asm.ClassReader;
import org.springframework.asm.ClassVisitor;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.metadata.internal.model.BeanMetadataModel;
import org.springframework.ide.eclipse.beans.core.metadata.model.BeanMetadataProviderAdapter;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadata;
import org.springframework.ide.eclipse.beans.core.metadata.model.IBeanMetadataProvider;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.java.annotation.IAnnotationMetadata;
import org.springframework.ide.eclipse.core.type.asm.CachingClassReaderFactory;
import org.springframework.ide.eclipse.core.type.asm.ClassReaderFactory;

public abstract class AbstractAnnotationReadingMetadataProvider
extends BeanMetadataProviderAdapter
implements IBeanMetadataProvider {
    private final Map<IProject, ClassReaderFactory> classReaderFactoryCache = new ConcurrentHashMap<IProject, ClassReaderFactory>();
    private final Map<IType, IAnnotationMetadata> metadataCache = new ConcurrentHashMap<IType, IAnnotationMetadata>();

    @Override
    public final Set<IBeanMetadata> provideBeanMetadata(IBean bean, IBeansConfig beansConfig, IProgressMonitor progressMonitor) {
        long start = System.currentTimeMillis();
        HashSet<IBeanMetadata> beanMetadata = new HashSet<IBeanMetadata>();
        IType type = JdtUtils.getJavaType((IProject)bean.getElementResource().getProject(), (String)BeansModelUtils.getBeanClass((IBean)bean, null));
        IAnnotationMetadata visitor = this.getAnnotationMetadata(bean, beansConfig.getElementResource().getProject(), type);
        if (visitor != null) {
            this.processFoundAnnotations(bean, beanMetadata, type, visitor, progressMonitor);
        }
        if (BeanMetadataModel.DEBUG) {
            System.out.println("Processing bean [" + bean + "] took " + (System.currentTimeMillis() - start) + "ms");
        }
        return beanMetadata;
    }

    protected IAnnotationMetadata getAnnotationMetadata(IBean bean, IProject project, IType type) {
        AnnotationMetadataReadingVisitor annotationVisitor;
        IType orginalType = type;
        if (type == null || type.isBinary()) {
            return null;
        }
        if (this.metadataCache.containsKey(orginalType)) {
            return this.metadataCache.get(orginalType);
        }
        AnnotationMetadataReadingVisitor visitor = null;
        ClassReaderFactory classReaderFactory = this.getClassReaderFactory(project);
        ClassLoader classLoader = JdtUtils.getClassLoader((IProject)project, null);
        IProject beansProject = bean.getElementResource().getProject();
        visitor = annotationVisitor = this.createAnnotationMetadataReadingVisitor();
        this.runAnnotationMetadataVisitor(type, classReaderFactory, classLoader, beansProject, annotationVisitor);
        if (visitor != null) {
            this.metadataCache.put(orginalType, (IAnnotationMetadata)visitor);
        }
        return visitor;
    }

    public void runAnnotationMetadataVisitor(IType type, ClassReaderFactory classReaderFactory, ClassLoader classLoader, IProject beansProject, AnnotationMetadataReadingVisitor annotationVisitor) {
        String className = type.getFullyQualifiedName();
        try {
            while (className != null && !Object.class.getName().equals(className) && type != null && !type.isBinary()) {
                ClassReader classReader = classReaderFactory.getClassReader(className);
                annotationVisitor.setType(type);
                annotationVisitor.setClassloader(classLoader);
                classReader.accept((ClassVisitor)annotationVisitor, 0);
                className = annotationVisitor.getSuperClassName();
                type = JdtUtils.getJavaType((IProject)beansProject, (String)className);
            }
        }
        catch (IOException e) {
            BeansCorePlugin.log((String)"Error during AST class visiting", (Throwable)e);
        }
    }

    private ClassReaderFactory getClassReaderFactory(IProject project) {
        if (!this.classReaderFactoryCache.containsKey(project)) {
            this.classReaderFactoryCache.put(project, (ClassReaderFactory)new CachingClassReaderFactory(JdtUtils.getClassLoader((IProject)project, null)));
        }
        return this.classReaderFactoryCache.get(project);
    }

    protected AnnotationMetadataReadingVisitor createAnnotationMetadataReadingVisitor() {
        return new AnnotationMetadataReadingVisitor();
    }

    protected abstract void processFoundAnnotations(IBean var1, Set<IBeanMetadata> var2, IType var3, IAnnotationMetadata var4, IProgressMonitor var5);
}

