/*
 * Decompiled with CFR 0.152.
 */
package org.testng.eclipse.ui.tree;

import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.testng.eclipse.ui.ImagesUtil;
import org.testng.eclipse.ui.RunInfo;
import org.testng.eclipse.ui.tree.ITreeItem;

public abstract class BaseTreeItem
implements ITreeItem {
    private static final String DATA_TREE_ITEM = "treeItem";
    private float m_time;
    private TreeItem m_treeItem;
    private RunInfo m_runInfo;
    private Integer m_testState = 0;

    public static ITreeItem getTreeItem(TreeItem ti) {
        return (ITreeItem)ti.getData(DATA_TREE_ITEM);
    }

    public BaseTreeItem(TreeItem parent, RunInfo runInfo) {
        this.m_treeItem = new TreeItem(parent, 0);
        this.init(runInfo);
    }

    public BaseTreeItem(Tree parent, RunInfo runInfo) {
        this.m_treeItem = new TreeItem(parent, 0);
        this.init(runInfo);
    }

    private void init(RunInfo runInfo) {
        this.m_runInfo = runInfo;
        this.m_treeItem.setExpanded(true);
        this.m_treeItem.setData(DATA_TREE_ITEM, (Object)this);
    }

    @Override
    public void addToCumulatedTime(RunInfo runInfo) {
        this.m_time += (float)runInfo.getTime();
        this.update(runInfo);
    }

    protected float getTime() {
        return this.m_time;
    }

    @Override
    public TreeItem getTreeItem() {
        return this.m_treeItem;
    }

    @Override
    public RunInfo getRunInfo() {
        return this.m_runInfo;
    }

    protected void maybeUpdateImage(RunInfo runInfo) {
        int status = runInfo.getStatus();
        TreeItem treeItem = this.getTreeItem();
        if (this.m_testState == 0 || this.isNewState(status)) {
            treeItem.setImage(ImagesUtil.getSuiteImage(status));
            this.m_testState = status;
        }
    }

    private boolean isNewState(int state) {
        switch (this.m_testState) {
            case 16: {
                return state != 16;
            }
            case 1: {
                return state != 16 && state != 1;
            }
            case 4: {
                return state == 2 || state == 3;
            }
            case 3: {
                return state == 2;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("Illegal state: " + state);
    }
}

