/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor.scanner;

import java.util.ArrayList;
import org.dadacoalition.yedit.Activator;
import org.dadacoalition.yedit.editor.ColorManager;
import org.dadacoalition.yedit.editor.scanner.AnchorWordDetector;
import org.dadacoalition.yedit.editor.scanner.DocumentStartAndEndRule;
import org.dadacoalition.yedit.editor.scanner.DoubleQuotedKeyRule;
import org.dadacoalition.yedit.editor.scanner.IndicatorCharacterRule;
import org.dadacoalition.yedit.editor.scanner.KeyRule;
import org.dadacoalition.yedit.editor.scanner.PredefinedValueRule;
import org.dadacoalition.yedit.editor.scanner.ScalarRule;
import org.dadacoalition.yedit.editor.scanner.SingleQuotedKeyRule;
import org.dadacoalition.yedit.editor.scanner.TagWordDetector;
import org.dadacoalition.yedit.editor.scanner.WhitespaceRule;
import org.dadacoalition.yedit.editor.scanner.YAMLToken;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.BufferedRuleBasedScanner;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.WordPatternRule;
import org.eclipse.swt.graphics.RGB;

public class YAMLScanner
extends BufferedRuleBasedScanner {
    private ColorManager colorManager;

    public YAMLScanner(ColorManager colorManager) {
        this.colorManager = colorManager;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        TextAttribute keyAttr = this.tokenAttribute(store, "colorKeyPreference", "boldKeyPreference", "italicKeyPreference", "underlineKeyPreference");
        YAMLToken keyToken = new YAMLToken(keyAttr, YAMLToken.KEY);
        TextAttribute scalarAttr = this.tokenAttribute(store, "colorScalarPreference", "boldScalarPreference", "italicScalarPreference", "underlineScalarPreference");
        YAMLToken scalarToken = new YAMLToken(scalarAttr, YAMLToken.SCALAR);
        TextAttribute commentAttr = this.tokenAttribute(store, "colorCommentPreference", "boldCommentPreference", "italicCommentPreference", "underlineCommentPreference");
        YAMLToken commentToken = new YAMLToken(commentAttr, YAMLToken.COMMENT);
        TextAttribute documentAttr = this.tokenAttribute(store, "colorDocumentPreference", "boldDocumentPreference", "italicDocumentPreference", "underlineDocumentPreference");
        YAMLToken documentStartToken = new YAMLToken(documentAttr, YAMLToken.DOCUMENT_START);
        YAMLToken documentEndToken = new YAMLToken(documentAttr, YAMLToken.DOCUMENT_END);
        TextAttribute anchorAttr = this.tokenAttribute(store, "colorAnchorPreferences", "boldAnchorPreference", "italicAnchorPreference", "underlineAnchorPreference");
        YAMLToken anchorToken = new YAMLToken(anchorAttr, YAMLToken.ANCHOR);
        TextAttribute aliasAttr = this.tokenAttribute(store, "colorAliasPreferences", "boldAliasPreference", "italicAliasPreference", "underlineAliasPreference");
        YAMLToken aliasToken = new YAMLToken(aliasAttr, YAMLToken.ALIAS);
        YAMLToken indicatorCharToken = new YAMLToken(new TextAttribute(null), YAMLToken.INDICATOR_CHARACTER);
        TextAttribute tagAttr = this.tokenAttribute(store, "colorTagPropertyPreferences", "boldTagPropertyPreference", "italicTagPropertyPreference", "underlineTagPropertyPreference");
        YAMLToken tagPropToken = new YAMLToken(tagAttr, YAMLToken.TAG_PROPERTY);
        TextAttribute constantAttr = this.tokenAttribute(store, "colorConstantPreferences", "boldConstantPreference", "italicConstantPreference", "underlineConstantPreference");
        YAMLToken predefinedValToken = new YAMLToken(constantAttr, YAMLToken.CONSTANT);
        YAMLToken whitespaceToken = new YAMLToken(new TextAttribute(null), YAMLToken.WHITESPACE);
        YAMLToken directiveToken = new YAMLToken(new TextAttribute(null), YAMLToken.DIRECTIVE);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new KeyRule((IToken)keyToken));
        rules.add(new SingleQuotedKeyRule((IToken)keyToken));
        rules.add(new DoubleQuotedKeyRule((IToken)keyToken));
        rules.add(new MultiLineRule("\"", "\"", (IToken)scalarToken, '\\'));
        rules.add(new MultiLineRule("'", "'", (IToken)scalarToken));
        rules.add(new EndOfLineRule("#", (IToken)commentToken));
        rules.add(new EndOfLineRule("%TAG", (IToken)directiveToken));
        rules.add(new EndOfLineRule("%YAML", (IToken)directiveToken));
        rules.add(new DocumentStartAndEndRule("---", (IToken)documentStartToken));
        rules.add(new DocumentStartAndEndRule("...", (IToken)documentEndToken));
        rules.add(new IndicatorCharacterRule((IToken)indicatorCharToken));
        rules.add(new WhitespaceRule((IToken)whitespaceToken));
        rules.add(new WordPatternRule((IWordDetector)new AnchorWordDetector(), "&", "", (IToken)anchorToken));
        rules.add(new WordPatternRule((IWordDetector)new AnchorWordDetector(), "*", "", (IToken)aliasToken));
        rules.add(new WordPatternRule((IWordDetector)new TagWordDetector(), "!", "", (IToken)tagPropToken));
        rules.add(new PredefinedValueRule((IToken)predefinedValToken));
        rules.add(new ScalarRule((IToken)scalarToken));
        IRule[] rulesArray = new IRule[rules.size()];
        rules.toArray(rulesArray);
        this.setRules(rulesArray);
        this.setDefaultReturnToken((IToken)scalarToken);
    }

    private TextAttribute tokenAttribute(IPreferenceStore store, String colorPrefs, String boldPrefs, String italicPrefs, String underlinePrefs) {
        boolean isUnderline;
        boolean isItalic;
        int style = 0;
        boolean isBold = store.getBoolean(boldPrefs);
        if (isBold) {
            style |= 1;
        }
        if (isItalic = store.getBoolean(italicPrefs)) {
            style |= 2;
        }
        if (isUnderline = store.getBoolean(underlinePrefs)) {
            style |= 0x40000000;
        }
        RGB color = PreferenceConverter.getColor((IPreferenceStore)store, (String)colorPrefs);
        TextAttribute attr = new TextAttribute(this.colorManager.getColor(color), null, style);
        return attr;
    }
}

