/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import org.dadacoalition.yedit.YEditLog;
import org.dadacoalition.yedit.editor.EditorUtils;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Point;

public class YEditDoubleClickStrategy
extends DefaultTextDoubleClickStrategy {
    public void doubleClicked(ITextViewer part) {
        IDocument doc = part.getDocument();
        Point selectionRange = part.getSelectedRange();
        int offset = selectionRange.x;
        boolean actionCompleted = false;
        try {
            SelectDirection selectDirection = this.checkCharAtSelection(doc, offset);
            if (SelectDirection.NONE != selectDirection) {
                YEditLog.logger.fine("Found quoted scalar at position " + offset + " on line" + EditorUtils.getLine(doc, offset));
                Point selection = this.calculateSelectionRange(selectDirection, doc, offset);
                if (selection != null) {
                    part.setSelectedRange(selection.x, selection.y);
                    actionCompleted = true;
                }
            } else {
                YEditLog.logger.fine("Found not quoted scalar at position " + offset + " on line" + EditorUtils.getLine(doc, offset));
            }
        }
        catch (BadLocationException e) {
            YEditLog.logException(e, "Failure during doubleclick action");
        }
        if (!actionCompleted) {
            super.doubleClicked(part);
        }
    }

    protected Point calculateSelectionRange(SelectDirection selectDirection, IDocument document, int offset) throws BadLocationException {
        char quoteChar = selectDirection.quoteChar();
        int x = -1;
        int y = -1;
        int docLength = document.getLength();
        if (selectDirection.isForward()) {
            int i = offset;
            while (i < docLength) {
                char currChar = document.getChar(i);
                if (currChar == quoteChar) {
                    x = offset;
                    y = i - offset;
                    break;
                }
                ++i;
            }
        } else {
            int i = offset - 1;
            while (i >= 0) {
                char currChar = document.getChar(i);
                if (currChar == quoteChar) {
                    x = i + 1;
                    y = offset - x;
                    break;
                }
                --i;
            }
        }
        if (-1 == x || -1 == y) {
            return null;
        }
        return new Point(x, y);
    }

    protected SelectDirection checkCharAtSelection(IDocument document, int offset) throws BadLocationException {
        if (offset == 0) {
            return SelectDirection.NONE;
        }
        if (document.getLength() == offset) {
            return SelectDirection.NONE;
        }
        String prevChar = document.get(offset - 1, 1);
        String nextChar = document.get(offset, 1);
        if ("'".equals(prevChar)) {
            return SelectDirection.FORWARD_SINGLE;
        }
        if ("\"".equals(prevChar)) {
            return SelectDirection.FORWARD_DOUBLE;
        }
        if ("'".equals(nextChar)) {
            return SelectDirection.BACKWARD_SINGLE;
        }
        if ("\"".equals(nextChar)) {
            return SelectDirection.BACKWARD_DOUBLE;
        }
        return SelectDirection.NONE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SelectDirection {
        FORWARD_SINGLE,
        BACKWARD_SINGLE,
        FORWARD_DOUBLE,
        BACKWARD_DOUBLE,
        NONE;


        protected char quoteChar() {
            if (this.equals((Object)BACKWARD_SINGLE) || this.equals((Object)FORWARD_SINGLE)) {
                return '\'';
            }
            return '\"';
        }

        protected boolean isForward() {
            return this.equals((Object)FORWARD_DOUBLE) || this.equals((Object)FORWARD_SINGLE);
        }
    }
}

