/*
 * Decompiled with CFR 0.152.
 */
package org.dadacoalition.yedit.editor;

import org.dadacoalition.yedit.YEditLog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;

public class YEditDamageRepairer
extends DefaultDamagerRepairer {
    public static final int MAX_COMPLETE_LINE_DAMAGE = 200;
    public static final int CHARS_TO_DAMAGE = 25;

    public YEditDamageRepairer(ITokenScanner scanner) {
        super(scanner);
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        IRegion damagedRegion = null;
        try {
            IDocument doc = e.getDocument();
            IRegion damagedLine = doc.getLineInformationOfOffset(e.getOffset());
            damagedRegion = damagedLine.getLength() > 200 ? this.calculateRegionToDamage(e.getOffset(), doc) : super.getDamageRegion(partition, e, documentPartitioningChanged);
        }
        catch (BadLocationException ex) {
            YEditLog.logException(ex, "Failed to get the region for a document change.");
        }
        return damagedRegion;
    }

    private IRegion calculateRegionToDamage(int offset, IDocument doc) throws BadLocationException {
        int endDamageOffset;
        int damagedLineNum = doc.getLineOfOffset(offset);
        int lineOffset = doc.getLineOffset(damagedLineNum);
        int damagedLineLength = doc.getLineLength(damagedLineNum);
        int startDamageOffset = offset - 25;
        if (startDamageOffset < lineOffset) {
            startDamageOffset = lineOffset;
        }
        if ((endDamageOffset = offset + 25) > lineOffset + damagedLineLength) {
            endDamageOffset = lineOffset + damagedLineLength;
        }
        Region regionToDamage = new Region(startDamageOffset, endDamageOffset - startDamageOffset);
        return regionToDamage;
    }
}

