/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.model;

import java.util.Collection;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Path;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansJavaConfig;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanConstructorArgument;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeanReference;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansList;
import org.springframework.ide.eclipse.beans.core.model.IBeansMap;
import org.springframework.ide.eclipse.beans.core.model.IBeansMapEntry;
import org.springframework.ide.eclipse.beans.core.model.IBeansProperties;
import org.springframework.ide.eclipse.beans.core.model.IBeansSet;
import org.springframework.ide.eclipse.beans.core.model.IBeansTypedString;
import org.springframework.ide.eclipse.beans.ui.BeansUILabels;
import org.springframework.ide.eclipse.core.io.ZipEntryStorage;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISourceModelElement;
import org.springframework.util.StringUtils;

public final class BeansModelLabels
extends BeansUILabels {
    public static String getElementLabel(IModelElement element, int flags) {
        StringBuffer buf = new StringBuffer(60);
        BeansModelLabels.appendElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void appendElementLabel(IModelElement element, int flags, StringBuffer buf) {
        if (BeansModelLabels.isFlagged(flags, 1)) {
            BeansModelLabels.appendElementPathLabel(element, flags, buf);
            buf.append(" - ");
        }
        if (element instanceof IBeansConfig) {
            BeansModelLabels.appendBeansConfigLabel((IBeansConfig)element, flags, buf);
        } else if (element instanceof IBeansConfigSet) {
            buf.append(element.getElementName());
            IBeansConfigSet configSet = (IBeansConfigSet)element;
            if (configSet.getProfiles() != null && configSet.getProfiles().size() > 0) {
                buf.append(" profiles=\"").append(StringUtils.collectionToDelimitedString((Collection)configSet.getProfiles(), (String)", ")).append("\"");
            }
        } else if (element instanceof ISourceModelElement) {
            BeansModelLabels.appendElementLabel((IModelElement)((ISourceModelElement)element), buf);
        } else {
            buf.append(element.getElementName());
        }
        if (BeansModelLabels.isFlagged(flags, 2)) {
            buf.append(" - ");
            BeansModelLabels.appendElementPathLabel(element, flags, buf);
        }
    }

    public static void appendElementPathLabel(IModelElement element, int flags, StringBuffer buf) {
        if (element instanceof IResourceModelElement) {
            IResource resource = ((IResourceModelElement)element).getElementResource();
            String path = element instanceof IBeansConfig && BeansModelLabels.isFlagged(flags, 4) ? resource.getFullPath().makeRelative().removeLastSegments(1).toString() : resource.getProjectRelativePath().makeRelative().toString();
            buf.append(path);
            if (element instanceof IBeanConstructorArgument || element instanceof IBeanProperty) {
                buf.append(" - ");
                buf.append(element.getElementParent().getElementName());
            }
        }
    }

    public static void appendBeansConfigLabel(IBeansConfig config, int flags, StringBuffer buf) {
        if (config instanceof BeansJavaConfig) {
            BeansJavaConfig javaConfig = (BeansJavaConfig)config;
            buf.append(javaConfig.getConfigClass().getElementName());
        } else {
            String configName = config.getElementName();
            if (config.isElementArchived()) {
                ZipEntryStorage storage = new ZipEntryStorage((IResourceModelElement)config);
                buf.append(storage.getFullPath());
                buf.append(" - ");
                buf.append(storage.getFile().getName());
            } else {
                buf.append(new Path(configName).lastSegment());
            }
        }
        if (!BeansModelLabels.isFlagged(flags, 4)) {
            if (StringUtils.hasLength((String)config.getDefaultLazyInit()) && !config.getDefaultLazyInit().equals("false")) {
                buf.append(" lazy-init=\"");
                buf.append(config.getDefaultLazyInit());
                buf.append('\"');
            }
            if (StringUtils.hasLength((String)config.getDefaultAutowire()) && !config.getDefaultAutowire().equals("no")) {
                buf.append(" autowire=\"");
                buf.append(config.getDefaultAutowire());
                buf.append('\"');
            }
            if (StringUtils.hasLength((String)config.getDefaultDependencyCheck()) && !config.getDefaultDependencyCheck().equals("none")) {
                buf.append(" dependency-check=\"");
                buf.append(config.getDefaultDependencyCheck());
                buf.append('\"');
            }
            if (StringUtils.hasLength((String)config.getDefaultInitMethod()) && !config.getDefaultInitMethod().equals("")) {
                buf.append(" init-method=\"");
                buf.append(config.getDefaultInitMethod());
                buf.append('\"');
            }
            if (StringUtils.hasLength((String)config.getDefaultDestroyMethod()) && !config.getDefaultDestroyMethod().equals("")) {
                buf.append(" destroy-method=");
                buf.append(config.getDefaultDestroyMethod());
                buf.append('\"');
            }
            if (StringUtils.hasLength((String)config.getDefaultMerge()) && !config.getDefaultMerge().equals("false")) {
                buf.append(" merge=\"");
                buf.append(config.getDefaultMerge());
                buf.append('\"');
            }
        }
    }

    public static void appendBeanLabel(IBean bean, StringBuffer buf) {
        if (!bean.isInnerBean()) {
            buf.append(bean.getElementName()).append(' ');
        }
        if (bean.getAliases() != null && bean.getAliases().length > 0) {
            buf.append('\'');
            buf.append(StringUtils.arrayToDelimitedString((Object[])bean.getAliases(), (String)", "));
            buf.append('\'');
        }
        if (bean.getClassName() != null) {
            buf.append('[').append(bean.getClassName()).append(']');
        } else if (bean.getParentName() != null) {
            buf.append('<').append(bean.getParentName()).append('>');
        }
    }

    public static void appendElementLabel(IModelElement element, StringBuffer buf) {
        if (element instanceof IBeansList) {
            buf.append("list");
        } else if (element instanceof IBeansSet) {
            buf.append("set");
        } else if (element instanceof IBeansMap) {
            buf.append("map");
        } else if (element instanceof IBeansMapEntry) {
            buf.append("entry");
        } else if (element instanceof IBeansProperties) {
            buf.append("props");
        } else if (element instanceof IBeanReference) {
            buf.append('<');
            buf.append(((IBeanReference)element).getBeanName());
            buf.append('>');
        } else if (element instanceof IBeansTypedString) {
            buf.append(((IBeansTypedString)element).getString());
        } else {
            buf.append(element.getElementName());
        }
    }
}

