/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.conflicts;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.compare.internal.CompareAction;
import org.eclipse.compare.internal.CompareEditor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.commands.GetStatusCommand;
import org.tigris.subversion.subclipse.core.commands.RevertResourcesCommand;
import org.tigris.subversion.subclipse.core.resources.SVNTreeConflict;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.Messages;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.compare.SVNLocalCompareInput;
import org.tigris.subversion.subclipse.ui.conflicts.ResolveTreeConflictWizardMainPage;
import org.tigris.subversion.subclipse.ui.conflicts.TreeConflictsView;
import org.tigris.subversion.subclipse.ui.operations.ResolveOperation;
import org.tigris.subversion.subclipse.ui.operations.ShowDifferencesAsUnifiedDiffOperationWC;
import org.tigris.subversion.subclipse.ui.wizards.SizePersistedWizardDialog;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class ResolveTreeConflictWizard
extends Wizard {
    private SVNTreeConflict treeConflict;
    private IWorkbenchPart targetPart;
    private ISVNLocalResource svnResource;
    private ResolveTreeConflictWizardMainPage mainPage;
    private ISVNStatus[] statuses;
    private boolean copiedToRetrieved;
    private boolean remoteCopiedToRetrieved;
    private ISVNStatus copiedTo;
    private ISVNStatus remoteCopiedTo;
    private ISVNLogMessage[] logMessages;
    private boolean added;
    private Exception mergeException;
    private Exception revertException;
    private boolean compare;
    private File mergePath;
    private ISVNClientAdapter svnClient;

    public ResolveTreeConflictWizard(SVNTreeConflict treeConflict, IWorkbenchPart targetPart) {
        this.treeConflict = treeConflict;
        this.targetPart = targetPart;
        this.svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)treeConflict.getResource());
        try {
            this.added = this.svnResource.isAdded();
        }
        catch (SVNException e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
        }
    }

    public void addPages() {
        super.addPages();
        this.setWindowTitle(String.valueOf(Messages.ResolveTreeConflictWizard_title) + this.treeConflict.getResource().getName());
        this.mainPage = new ResolveTreeConflictWizardMainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        if (this.mainPage.getReplace()) {
            this.mergeException = null;
            try {
                BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable(){

                    public void run() {
                        try {
                            SVNRevision revision;
                            ResolveTreeConflictWizard.this.svnClient = ResolveTreeConflictWizard.this.svnResource.getRepository().getSVNClient();
                            File file = ResolveTreeConflictWizard.this.svnResource.getResource().getLocation().toFile();
                            ResolveTreeConflictWizard.this.svnClient.remove(new File[]{file}, true);
                            SVNUrl url = new SVNUrl(String.valueOf(ResolveTreeConflictWizard.this.treeConflict.getConflictDescriptor().getSrcRightVersion().getReposURL()) + "/" + ResolveTreeConflictWizard.this.treeConflict.getConflictDescriptor().getSrcRightVersion().getPathInRepos());
                            int index = ResolveTreeConflictWizard.this.treeConflict.getConflictDescriptor().getSrcRightVersion().toString().lastIndexOf("@");
                            if (index == -1) {
                                revision = SVNRevision.HEAD;
                            } else {
                                long number = Long.parseLong(ResolveTreeConflictWizard.this.treeConflict.getConflictDescriptor().getSrcRightVersion().toString().substring(index + 1));
                                revision = new SVNRevision.Number(number);
                            }
                            ResolveTreeConflictWizard.this.svnClient.copy(url, file, revision);
                        }
                        catch (Exception e) {
                            ResolveTreeConflictWizard.this.mergeException = e;
                        }
                    }
                });
                if (this.mergeException != null) {
                    SVNUIPlugin.log(4, this.mergeException.getMessage(), this.mergeException);
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ResolveTreeConflictWizard_2, (String)this.mergeException.getMessage());
                    return false;
                }
                this.svnResource.getResource().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                return true;
            }
            catch (Exception e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ResolveTreeConflictWizard_2, (String)e.getMessage());
                return false;
            }
        }
        this.compare = this.mainPage.getCompare();
        if (this.mainPage.getMergeFromRepository()) {
            block25: {
                try {
                    final SVNUrl url = new SVNUrl(this.mainPage.getMergeFromUrl());
                    SVNRevision.Number revision1 = this.treeConflict.getConflictDescriptor().getSrcLeftVersion().getPegRevision() == this.treeConflict.getConflictDescriptor().getSrcRightVersion().getPegRevision() ? new SVNRevision.Number(this.treeConflict.getConflictDescriptor().getSrcLeftVersion().getPegRevision() - 1L) : new SVNRevision.Number(this.treeConflict.getConflictDescriptor().getSrcLeftVersion().getPegRevision());
                    SVNRevision.Number revision2 = new SVNRevision.Number(this.treeConflict.getConflictDescriptor().getSrcRightVersion().getPegRevision());
                    if (this.treeConflict.getConflictDescriptor().getSrcLeftVersion().getPegRevision() == this.treeConflict.getConflictDescriptor().getSrcRightVersion().getPegRevision()) {
                        revision1 = new SVNRevision.Number(this.treeConflict.getConflictDescriptor().getSrcLeftVersion().getPegRevision() - 1L);
                    }
                    final IResource mergeTarget = this.mainPage.getMergeTarget();
                    SVNRevision.Number rev1 = revision1;
                    this.svnClient = this.svnResource.getRepository().getSVNClient();
                    this.mergeException = null;
                    BusyIndicator.showWhile((Display)Display.getDefault(), (Runnable)new Runnable((SVNRevision)rev1, (SVNRevision)revision2){
                        private final /* synthetic */ SVNRevision val$rev1;
                        private final /* synthetic */ SVNRevision val$revision2;
                        {
                            this.val$rev1 = sVNRevision;
                            this.val$revision2 = sVNRevision2;
                        }

                        public void run() {
                            block5: {
                                try {
                                    ResolveTreeConflictWizard.this.mergePath = mergeTarget.getLocation().toFile();
                                    ResolveTreeConflictWizard.this.svnClient.merge(url, this.val$rev1, url, this.val$revision2, ResolveTreeConflictWizard.this.mergePath, true, false, false, true);
                                    try {
                                        if (mergeTarget.getParent() != null) {
                                            mergeTarget.getParent().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                            break block5;
                                        }
                                        mergeTarget.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                    catch (CoreException coreException) {}
                                }
                                catch (Exception e) {
                                    ResolveTreeConflictWizard.this.mergeException = e;
                                }
                            }
                        }
                    });
                    if (this.mergeException == null) break block25;
                    SVNUIPlugin.log(4, this.mergeException.getMessage(), this.mergeException);
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ResolveTreeConflictWizard_mergeError, (String)this.mergeException.getMessage());
                }
                catch (Throwable throwable) {
                    this.svnResource.getRepository().returnSVNClient(this.svnClient);
                    throw throwable;
                }
                {
                    catch (Exception e) {
                        SVNUIPlugin.log(4, e.getMessage(), e);
                        MessageDialog.openError((Shell)this.getShell(), (String)Messages.ResolveTreeConflictWizard_mergeError, (String)e.getMessage());
                    }
                }
                this.svnResource.getRepository().returnSVNClient(this.svnClient);
                return false;
            }
            this.svnResource.getRepository().returnSVNClient(this.svnClient);
        }
        if (this.mainPage.getCompare()) {
            if (this.mainPage.getCompareResource2() == null) {
                ISVNLocalResource svnCompareResource = this.mainPage.getSvnCompareResource();
                if (svnCompareResource == null) {
                    svnCompareResource = this.svnResource;
                }
                ISVNRemoteResource remoteResource = this.mainPage.getRemoteResource();
                try {
                    File file = File.createTempFile("revision", ".diff");
                    file.deleteOnExit();
                    File path = new File(svnCompareResource.getResource().getLocation().toString());
                    SVNUrl toUrl = remoteResource.getUrl();
                    SVNRevision toRevision = remoteResource.getRevision();
                    ShowDifferencesAsUnifiedDiffOperationWC operation = new ShowDifferencesAsUnifiedDiffOperationWC(this.targetPart, path, toUrl, toRevision, file);
                    SVNLocalCompareInput compareInput = new SVNLocalCompareInput(svnCompareResource, remoteResource);
                    compareInput.setDiffOperation(operation);
                    CompareUI.openCompareEditorOnPage((CompareEditorInput)compareInput, (IWorkbenchPage)this.targetPart.getSite().getPage());
                    CompareCloseListener closeListener = new CompareCloseListener(String.valueOf(Messages.ResolveTreeConflictWizard_compare) + svnCompareResource.getName() + " <workspace>");
                    this.targetPart.getSite().getPage().addPartListener((IPartListener2)closeListener);
                }
                catch (Exception e) {
                    SVNUIPlugin.log(4, e.getMessage(), e);
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.ResolveTreeConflictWizard_compareError, (String)e.getMessage());
                    return false;
                }
            } else {
                IStructuredSelection selection = new IStructuredSelection(){

                    public Object getFirstElement() {
                        return ResolveTreeConflictWizard.this.mainPage.getCompareResource1();
                    }

                    public Iterator iterator() {
                        return this.toList().iterator();
                    }

                    public int size() {
                        return 2;
                    }

                    public Object[] toArray() {
                        Object[] compareResources = new IResource[]{ResolveTreeConflictWizard.this.mainPage.getCompareResource1(), ResolveTreeConflictWizard.this.mainPage.getCompareResource2()};
                        return compareResources;
                    }

                    public List toList() {
                        ArrayList<IResource> compareList = new ArrayList<IResource>();
                        compareList.add(ResolveTreeConflictWizard.this.mainPage.getCompareResource1());
                        compareList.add(ResolveTreeConflictWizard.this.mainPage.getCompareResource2());
                        return compareList;
                    }

                    public boolean isEmpty() {
                        return false;
                    }
                };
                CompareAction compareAction = new CompareAction();
                compareAction.setActivePart(null, this.targetPart);
                Action action = new Action(){};
                compareAction.selectionChanged((IAction)action, (ISelection)selection);
                compareAction.run((ISelection)selection);
                CompareCloseListener closeListener = new CompareCloseListener(String.valueOf(Messages.ResolveTreeConflictWizard_compare2) + this.mainPage.getCompareResource1().getName() + "' - '" + this.mainPage.getCompareResource2().getName() + "')");
                this.targetPart.getSite().getPage().addPartListener((IPartListener2)closeListener);
            }
        }
        if (this.mainPage.getRevertResource() != null) {
            this.revertException = null;
            BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                public void run() {
                    try {
                        IResource[] revertResources = new IResource[]{ResolveTreeConflictWizard.this.mainPage.getRevertResource()};
                        RevertResourcesCommand revertCommand = new RevertResourcesCommand(ResolveTreeConflictWizard.this.svnResource.getWorkspaceRoot(), revertResources);
                        revertCommand.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        ResolveTreeConflictWizard.this.revertException = e;
                    }
                }
            });
            if (this.revertException != null) {
                SVNUIPlugin.log(4, this.revertException.getMessage(), this.revertException);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ResolveTreeConflictWizard_revertError, (String)this.revertException.getMessage());
                return false;
            }
        }
        if (this.mainPage.getDeleteResource() != null) {
            try {
                this.mainPage.getDeleteResource().delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                SVNUIPlugin.log(4, e.getMessage(), e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.ResolveTreeConflictWizard_deleteError, (String)e.getMessage());
                return false;
            }
        }
        if (!this.mainPage.getMarkResolved()) {
            if (!this.mainPage.refreshConflicts()) return true;
        }
        try {
            if (this.mainPage.getMarkResolved()) {
                IResource[] resolvedResources = new IResource[]{this.treeConflict.getResource()};
                ResolveOperation resolveOperation = new ResolveOperation(this.targetPart, resolvedResources, 6){

                    protected boolean canRunAsJob() {
                        return false;
                    }
                };
                resolveOperation.run();
            }
            if (!this.mainPage.refreshConflicts()) return true;
            IResource[] refreshResources = new IResource[]{this.svnResource.getResource()};
            TreeConflictsView.refresh(refreshResources);
            return true;
        }
        catch (Exception e) {
            SVNUIPlugin.log(4, e.getMessage(), e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ResolveTreeConflictWizard_markResolvedError, (String)e.getMessage());
            return false;
        }
    }

    public SVNTreeConflict getTreeConflict() {
        return this.treeConflict;
    }

    public ISVNLocalResource getSvnResource() {
        return this.svnResource;
    }

    public boolean isAdded() {
        return this.added;
    }

    public ISVNStatus getLocalCopiedTo(boolean getAll) throws SVNException, SVNClientException {
        int index;
        String endsWithCheck = this.treeConflict.getConflictDescriptor().getSrcRightVersion().getPathInRepos();
        IProject project = this.svnResource.getResource().getProject();
        if (project != null && (index = endsWithCheck.indexOf("/" + project.getName() + "/")) != -1) {
            endsWithCheck = endsWithCheck.substring(index);
        }
        if (this.copiedTo == null && !this.copiedToRetrieved) {
            this.statuses = this.getStatuses(getAll);
            ISVNClientAdapter svnClient = this.svnResource.getRepository().getSVNClient();
            int i = 0;
            while (i < this.statuses.length) {
                ISVNInfo info;
                if (this.statuses[i].isCopied() && this.statuses[i].getTextStatus().equals((Object)SVNStatusKind.ADDED) && (info = svnClient.getInfoFromWorkingCopy(this.statuses[i].getFile())).getCopyUrl() != null && (this.svnResource.getUrl() != null && info.getCopyUrl().toString().equals(this.svnResource.getUrl().toString()) || info.getCopyUrl().toString().endsWith(endsWithCheck))) {
                    this.copiedTo = this.statuses[i];
                    break;
                }
                ++i;
            }
            this.svnResource.getRepository().returnSVNClient(svnClient);
        }
        this.copiedToRetrieved = true;
        return this.copiedTo;
    }

    public ISVNStatus getRemoteCopiedTo(boolean getAll) throws Exception {
        if (this.remoteCopiedTo == null && !this.remoteCopiedToRetrieved) {
            this.remoteCopiedToRetrieved = true;
            this.logMessages = this.getLogMessages();
            if (this.logMessages != null) {
                int i = 0;
                while (i < this.logMessages.length) {
                    ISVNLogMessageChangePath[] changePaths = this.logMessages[i].getChangedPaths();
                    int j = 0;
                    while (j < changePaths.length) {
                        if (changePaths[j].getAction() == 'A' && changePaths[j].getCopySrcPath() != null && (this.svnResource.getUrl() != null && this.svnResource.getUrl().toString().endsWith(changePaths[j].getCopySrcPath()) || changePaths[j].getCopySrcPath().endsWith(this.svnResource.getIResource().getFullPath().toString()))) {
                            this.statuses = this.getStatuses(getAll);
                            int k = 0;
                            while (k < this.statuses.length) {
                                if (this.statuses[k].getUrl() != null && this.statuses[k].getUrl().toString().endsWith(changePaths[j].getPath())) {
                                    this.remoteCopiedTo = this.statuses[k];
                                    return this.remoteCopiedTo;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return this.remoteCopiedTo;
    }

    public ISVNStatus[] getAdds() throws SVNException {
        ArrayList<ISVNStatus> adds = new ArrayList<ISVNStatus>();
        this.statuses = this.getStatuses(false);
        int i = 0;
        while (i < this.statuses.length) {
            if (this.statuses[i].getTextStatus().equals((Object)SVNStatusKind.ADDED)) {
                adds.add(this.statuses[i]);
            }
            ++i;
        }
        ISVNStatus[] addArray = new ISVNStatus[adds.size()];
        adds.toArray(addArray);
        return addArray;
    }

    public boolean isCompare() {
        return this.compare;
    }

    private ISVNStatus[] getStatuses(boolean getAll) throws SVNException {
        if (this.statuses == null) {
            IProject project = this.treeConflict.getResource().getProject();
            if (project == null) {
                return new ISVNStatus[0];
            }
            ISVNLocalResource svnProject = SVNWorkspaceRoot.getSVNResourceFor((IResource)project);
            GetStatusCommand command = new GetStatusCommand(svnProject, true, getAll);
            command.run((IProgressMonitor)new NullProgressMonitor());
            this.statuses = command.getStatuses();
        }
        return this.statuses;
    }

    public File getMergePath() {
        return this.mergePath;
    }

    private ISVNLogMessage[] getLogMessages() throws Exception {
        if (this.logMessages == null) {
            ISVNClientAdapter svnClient = null;
            try {
                svnClient = this.svnResource.getRepository().getSVNClient();
                IProject project = this.treeConflict.getResource().getProject();
                ISVNLocalResource svnProject = SVNWorkspaceRoot.getSVNResourceFor((IResource)project);
                SVNRevision.Number revision1 = new SVNRevision.Number(this.treeConflict.getConflictDescriptor().getSrcLeftVersion().getPegRevision());
                SVNRevision.Number revision2 = new SVNRevision.Number(this.treeConflict.getConflictDescriptor().getSrcRightVersion().getPegRevision());
                this.logMessages = svnClient.getLogMessages(svnProject.getUrl(), (SVNRevision)revision1, (SVNRevision)revision2, true);
            }
            finally {
                this.svnResource.getRepository().returnSVNClient(svnClient);
            }
        }
        return this.logMessages;
    }

    class CompareCloseListener
    implements IPartListener2 {
        private String compareName;

        public CompareCloseListener(String compareName) {
            this.compareName = compareName;
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            CompareEditor editor;
            IEditorInput input;
            String name;
            IWorkbenchPart part = partRef.getPart(false);
            if (part instanceof CompareEditor && (name = (input = (editor = (CompareEditor)part).getEditorInput()).getName()) != null && name.startsWith(this.compareName)) {
                ResolveTreeConflictWizard.this.targetPart.getSite().getPage().removePartListener((IPartListener2)this);
                if (MessageDialog.openQuestion((Shell)ResolveTreeConflictWizard.this.getShell(), (String)Messages.ResolveTreeConflictWizard_editorClosed, (String)(String.valueOf(Messages.ResolveTreeConflictWizard_promptToReolve) + ResolveTreeConflictWizard.this.treeConflict.getResource().getName() + "?"))) {
                    ResolveTreeConflictWizard wizard = new ResolveTreeConflictWizard(ResolveTreeConflictWizard.this.treeConflict, ResolveTreeConflictWizard.this.targetPart);
                    SizePersistedWizardDialog dialog = new SizePersistedWizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard, "ResolveTreeConflict");
                    dialog.open();
                }
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    }
}

