/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.team.core.TeamException;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.tigris.subversion.subclipse.core.ISVNRemoteFile;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.resources.RemoteResource;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.actions.SVNAction;
import org.tigris.subversion.subclipse.ui.editor.RemoteFileEditorInput;
import org.tigris.subversion.svnclientadapter.SVNRevision;

public class OpenLogEntryAction
extends SVNAction {
    public void execute(IAction action) throws InterruptedException, InvocationTargetException {
        this.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                IWorkbench workbench = SVNUIPlugin.getPlugin().getWorkbench();
                IEditorRegistry registry = workbench.getEditorRegistry();
                IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
                ISVNRemoteResource[] entries = OpenLogEntryAction.this.getSelectedRemoteResources();
                int i = 0;
                while (i < entries.length) {
                    ISVNRemoteResource remoteResource = entries[i];
                    if (remoteResource instanceof ISVNRemoteFile) {
                        String filename;
                        IEditorDescriptor descriptor;
                        ISVNRemoteFile file = (ISVNRemoteFile)remoteResource;
                        if (file instanceof RemoteResource) {
                            ((RemoteResource)file).setPegRevision(SVNRevision.HEAD);
                        }
                        String id = (descriptor = registry.getDefaultEditor(filename = remoteResource.getName())) == null ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
                        try {
                            try {
                                page.openEditor((IEditorInput)new RemoteFileEditorInput(file, monitor), id);
                            }
                            catch (PartInitException e) {
                                if (id.equals("org.eclipse.ui.DefaultTextEditor")) {
                                    throw e;
                                }
                                page.openEditor((IEditorInput)new RemoteFileEditorInput(file, monitor), "org.eclipse.ui.DefaultTextEditor");
                            }
                        }
                        catch (PartInitException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    ++i;
                }
            }
        }, false, 2);
    }

    protected boolean isEnabled() throws TeamException {
        ISVNRemoteResource[] resources = this.getSelectedRemoteResources();
        if (resources.length == 0) {
            return false;
        }
        return resources[0] != null;
    }
}

