/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractTransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.internal.model.RenderActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IRenderActions;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.IViewState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ViewState
extends AbstractTransitionableFrom
implements IViewState,
ICloneableModelElement<IViewState> {
    private IRenderActions renderActions = null;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.renderActions = null;
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("render-actions".equals(child.getLocalName())) {
                    this.renderActions = new RenderActions();
                    this.renderActions.init(child, this);
                } else if ("on-render".equals(child.getLocalName())) {
                    this.renderActions = new RenderActions();
                    this.renderActions.init(child, this);
                }
                ++i;
            }
        }
    }

    @Override
    public String getView() {
        return this.getAttribute("view");
    }

    @Override
    public void setView(String view) {
        this.setAttribute("view", view);
    }

    @Override
    public IRenderActions getRenderActions() {
        return this.renderActions;
    }

    @Override
    public void createNew(IWebflowState parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("view-state");
        this.init(node, parent);
    }

    @Override
    public IViewState cloneModelElement() {
        ViewState state = new ViewState();
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        return state;
    }

    @Override
    public void applyCloneValues(IViewState element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setId(element.getId());
            this.setView(element.getView());
            this.init(element.getNode(), this.parent);
            super.fireStructureChange("move_children", new Integer(1));
        }
    }

    @Override
    public void setRenderActions(IRenderActions renderActions) {
        if (this.renderActions != null) {
            this.getNode().removeChild((Node)this.renderActions.getNode());
        }
        this.renderActions = renderActions;
        if (renderActions != null) {
            WebflowModelXmlUtils.insertNode((Node)renderActions.getNode(), (Node)this.getNode());
        }
        super.fireStructureChange("move_children", new Integer(1));
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            if (this.getEntryActions() != null) {
                this.getEntryActions().accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getRenderActions() != null) {
                this.getRenderActions().accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getExitActions() != null) {
                this.getExitActions().accept(visitor, monitor);
            }
            for (IExceptionHandler iExceptionHandler : this.getExceptionHandlers()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iExceptionHandler.accept(visitor, monitor);
            }
            for (ITransition iTransition : this.getOutputTransitions()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iTransition.accept(visitor, monitor);
            }
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.add(this.getEntryActions());
        children.add(this.getExitActions());
        children.add(this.getRenderActions());
        children.addAll(this.getExceptionHandlers());
        children.addAll(this.getOutputTransitions());
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public String getModel() {
        return this.getAttribute("model");
    }

    @Override
    public String getPopup() {
        return this.getAttribute("popup");
    }

    @Override
    public String getRedirect() {
        return this.getAttribute("redirect");
    }

    @Override
    public void setModel(String model) {
        this.setAttribute("model", model);
    }

    @Override
    public void setPopup(String popup) {
        this.setAttribute("popup", popup);
    }

    @Override
    public void setRedirect(String redirect) {
        this.setAttribute("redirect", redirect);
    }
}

