/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.tools.usage.util;

import java.util.Collection;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.osgi.framework.Bundle;
import org.tigris.subversion.subclipse.tools.usage.util.collectionfilter.CollectionFilterUtils;
import org.tigris.subversion.subclipse.tools.usage.util.collectionfilter.ICollectionFilter;

public class BundleUtils {
    public static void getBundles(ICollectionFilter filter, Collection filteredBundleCollection, Bundle[] bundles) {
        CollectionFilterUtils.filter(filter, bundles, filteredBundleCollection);
    }

    public static void getBundles(String bundleSymbolicNameRegex, Collection filteredBundleCollection, Bundle[] bundles) {
        BundleUtils.getBundles(new BundleSymbolicNameFilter(bundleSymbolicNameRegex), filteredBundleCollection, bundles);
    }

    public static class BundleSymbolicNameFilter
    implements ICollectionFilter {
        private Pattern pattern;

        public BundleSymbolicNameFilter(String symbolicNameRegex) {
            this.pattern = Pattern.compile(symbolicNameRegex);
        }

        public boolean matches(Object object) {
            if (object instanceof Bundle) {
                Bundle bundle = (Bundle)object;
                Assert.isTrue((bundle != null ? 1 : 0) != 0);
                return this.pattern.matcher(bundle.getSymbolicName()).matches();
            }
            return false;
        }
    }
}

