/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig.filters;

import java.util.ArrayList;
import java.util.List;
import net.sf.eclipsecs.core.projectconfig.filters.AbstractFilter;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PackageFilter
extends AbstractFilter {
    public static final String RECURSE_OFF_MARKER = "<recurse=false>";
    private List<String> mData = new ArrayList<String>();
    private boolean mExcludeSubPackages = true;

    @Override
    public boolean accept(Object element) {
        boolean goesThrough = true;
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            IContainer folder = null;
            folder = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
            IPath projRelativPath = folder.getProjectRelativePath();
            int size = this.mData != null ? this.mData.size() : 0;
            int i = 0;
            while (i < size) {
                String el = this.mData.get(i);
                if (!RECURSE_OFF_MARKER.equals(el)) {
                    Path filteredPath = new Path(el);
                    if (this.mExcludeSubPackages && filteredPath.isPrefixOf(projRelativPath)) {
                        goesThrough = false;
                        break;
                    }
                    if (!this.mExcludeSubPackages && filteredPath.equals((Object)projRelativPath)) {
                        goesThrough = false;
                        break;
                    }
                }
                ++i;
            }
        }
        return goesThrough;
    }

    @Override
    public void setFilterData(List<String> filterData) {
        if (filterData == null) {
            this.mData = new ArrayList<String>();
        }
        this.mData = filterData;
        if (this.mData.contains(RECURSE_OFF_MARKER)) {
            this.mExcludeSubPackages = false;
        }
    }

    @Override
    public List<String> getFilterData() {
        return this.mData;
    }

    @Override
    public String getPresentableFilterData() {
        StringBuffer buf = new StringBuffer();
        int size = this.mData != null ? this.mData.size() : 0;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.mData.get(i));
            ++i;
        }
        return buf.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof PackageFilter)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        PackageFilter rhs = (PackageFilter)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.mData, rhs.mData).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(7834681, 1000003).appendSuper(super.hashCode()).append(this.mData).toHashCode();
    }
}

