/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.eclipsecs.core.CheckstylePluginPrefs;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.builder.Auditor;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.jobs.AuditorJob;
import net.sf.eclipsecs.core.jobs.BuildProjectJob;
import net.sf.eclipsecs.core.nature.CheckstyleNature;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.ProjectConfigurationFactory;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;

public class CheckstyleBuilder
extends IncrementalProjectBuilder {
    public static final String BUILDER_ID = "net.sf.eclipsecs.core.CheckstyleBuilder";

    public static void buildProject(IProject project) {
        BuildProjectJob buildJob = new BuildProjectJob(project, 6);
        buildJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        buildJob.schedule();
    }

    public static void buildAllProjects() throws CheckstylePluginException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        CheckstyleBuilder.buildProjects(Arrays.asList(projects));
    }

    public static void buildProjects(Collection<IProject> projects) throws CheckstylePluginException {
        ArrayList<IProject> checkstyleProjects = new ArrayList<IProject>();
        for (IProject project : projects) {
            try {
                if (!project.exists() || !project.isOpen() || !project.hasNature("net.sf.eclipsecs.core.CheckstyleNature")) continue;
                checkstyleProjects.add(project);
            }
            catch (CoreException e) {
                CheckstylePluginException.rethrow(e);
            }
        }
        BuildProjectJob buildJob = new BuildProjectJob(checkstyleProjects.toArray(new IProject[checkstyleProjects.size()]), 6);
        buildJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        buildJob.schedule();
    }

    protected final IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        project.deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", false, 0);
        if (CheckstyleNature.hasCorrectBuilderOrder(project)) {
            IProjectConfiguration config = null;
            try {
                config = ProjectConfigurationFactory.getConfiguration(project);
            }
            catch (CheckstylePluginException e) {
                Status status = new Status(4, "net.sf.eclipsecs.core", 4, e.getMessage() != null ? e.getMessage() : Messages.CheckstyleBuilder_msgErrorUnknown, (Throwable)e);
                throw new CoreException((IStatus)status);
            }
            Collection<IResource> resources = null;
            IResourceDelta resourceDelta = this.getDelta(project);
            IFilter[] filters = config.getFilters().toArray(new IFilter[config.getFilters().size()]);
            resources = resourceDelta != null ? this.getResources(resourceDelta, filters) : this.getResources((IContainer)project, filters);
            this.handleBuildSelection(resources, config, monitor, project, kind);
        } else {
            project.deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", false, 2);
            HashMap<String, Object> markerAttributes = new HashMap<String, Object>();
            markerAttributes.put("priority", new Integer(2));
            markerAttributes.put("severity", new Integer(2));
            markerAttributes.put("message", NLS.bind((String)Messages.CheckstyleBuilder_msgWrongBuilderOrder, (Object)project.getName()));
            markerAttributes.put("categoryId", new Integer(999));
            IMarker marker = project.createMarker("net.sf.eclipsecs.core.CheckstyleMarker");
            marker.setAttributes(markerAttributes);
        }
        return new IProject[]{project};
    }

    public final <T extends IResource> void handleBuildSelection(Collection<T> resources, IProjectConfiguration configuration, IProgressMonitor monitor, IProject project, int kind) throws CoreException {
        if (kind == 6) {
            project.deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", false, 2);
        }
        boolean backgroundFullBuild = CheckstylePluginPrefs.getBoolean("background.full.build");
        try {
            List<FileSet> fileSets = configuration.getFileSets();
            HashMap<ICheckConfiguration, Auditor> audits = new HashMap<ICheckConfiguration, Auditor>();
            for (FileSet fileSet : fileSets) {
                if (!fileSet.isEnabled()) continue;
                ICheckConfiguration checkConfig = fileSet.getCheckConfig();
                if (checkConfig == null) {
                    throw new CheckstylePluginException(NLS.bind((String)Messages.errorNoCheckConfig, (Object)project.getName()));
                }
                Auditor audit = (Auditor)audits.get(checkConfig);
                if (audit == null) {
                    audit = new Auditor(checkConfig);
                    audits.put(checkConfig, audit);
                }
                for (IResource resource : resources) {
                    IFile file;
                    if (!(resource instanceof IFile) || !fileSet.includesFile(file = (IFile)resource)) continue;
                    audit.addFile(file);
                    file.deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", false, 0);
                    file.getParent().deleteMarkers("net.sf.eclipsecs.core.CheckstyleMarker", false, 0);
                }
            }
            for (Auditor audit : audits.values()) {
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                if (backgroundFullBuild && kind == 6) {
                    AuditorJob j = new AuditorJob(project, audit);
                    j.schedule();
                    continue;
                }
                audit.runAudit(project, monitor);
            }
        }
        catch (CheckstylePluginException e) {
            Status status = new Status(4, "net.sf.eclipsecs.core", 4, e.getLocalizedMessage(), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private Collection<IResource> getResources(IResourceDelta delta, IFilter[] filters) throws CoreException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren();
        int i = 0;
        while (i < affectedChildren.length) {
            IResourceDelta childDelta = affectedChildren[i];
            int deltaKind = childDelta.getKind();
            if (deltaKind == 1 || deltaKind == 4) {
                IResource child = childDelta.getResource();
                boolean goesThrough = true;
                int j = 0;
                while (j < filters.length) {
                    if (filters[j].isEnabled() && !filters[j].accept(child)) {
                        goesThrough = false;
                        break;
                    }
                    ++j;
                }
                if (goesThrough) {
                    resources.add(child);
                }
                if (child instanceof IContainer) {
                    resources.addAll(this.getResources(childDelta, filters));
                }
            }
            ++i;
        }
        return resources;
    }

    private Collection<IResource> getResources(IContainer container, IFilter[] filters) throws CoreException {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] children = container.members();
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            boolean goesThrough = true;
            int j = 0;
            while (j < filters.length) {
                if (filters[j].isEnabled() && !filters[j].accept(child)) {
                    goesThrough = false;
                    break;
                }
                ++j;
            }
            if (goesThrough) {
                resources.add(child);
            }
            if (child instanceof IContainer) {
                resources.addAll(this.getResources((IContainer)child, filters));
            }
            ++i;
        }
        return resources;
    }
}

