/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.editor.contentassist.webflow;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistCalculator;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistContext;
import org.springframework.ide.eclipse.beans.ui.editor.contentassist.IContentAssistProposalRecorder;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.ui.editor.WebflowNamespaceUtils;
import org.springframework.ide.eclipse.webflow.ui.editor.outline.webflow.WebflowUIImages;

public class SubflowReferenceContentAssistCalculator
implements IContentAssistCalculator {
    private static final int RELEVANCE = 10;

    public void computeProposals(IContentAssistContext context, IContentAssistProposalRecorder recorder) {
        IFile file = context.getFile();
        String[] stringArray = WebflowNamespaceUtils.getWebflowConfigNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String flowId = stringArray[n2];
            if (flowId.toLowerCase().startsWith(context.getMatchString().toLowerCase())) {
                this.acceptSearchMatch(recorder, flowId, file, context.getMatchString());
            }
            ++n2;
        }
    }

    private void acceptSearchMatch(IContentAssistProposalRecorder recorder, String flowId, IFile file, String prefix) {
        if (file != null && file.exists()) {
            IWebflowConfig config = Activator.getModel().getProject(file.getProject()).getConfig(flowId);
            String fileName = "";
            if (config != null) {
                fileName = config.getResource().getProjectRelativePath().toString();
            }
            String displayText = String.valueOf(flowId) + " - " + fileName;
            Image image = WebflowUIImages.getImage("org.springframework.ide.eclipse.webflow.ui.editor.spring_webflow_obj.gif");
            recorder.recordProposal(image, 10, displayText, flowId, (Object)config);
        }
    }
}

