/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.views;

import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.CounterPanel;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.FailureTrace;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.JUnitCopyAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.ShowNextFailureAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.ShowPreviousFailureAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.TestViewer;
import com.atlassian.theplugin.commons.bamboo.BuildDetails;
import com.atlassian.theplugin.commons.bamboo.TestDetails;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.text.NumberFormat;
import java.util.List;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultsView
extends ViewPart {
    public static final String ID = "com.atlassian.connector.eclipse.bamboo.ui.views.testResultView";
    static final int REFRESH_INTERVAL = 200;
    static final int LAYOUT_FLAT = 0;
    static final int LAYOUT_HIERARCHICAL = 1;
    private int fOrientation = 2;
    private int fCurrentOrientation;
    private BuildDetails fBuildDetails;
    private int fLayout = 1;
    protected Image fViewImage;
    protected CounterPanel fCounterPanel;
    protected boolean fShowOnErrorOnly = false;
    protected Clipboard fClipboard;
    protected volatile String fInfoMessage;
    private FailureTrace fFailureTrace;
    private TestViewer fTestViewer;
    private boolean fIsDisposed = false;
    private Action fNextAction;
    private Action fPreviousAction;
    private JUnitCopyAction fCopyAction;
    private Action fFailuresOnlyFilterAction;
    private ToggleOrientationAction[] fToggleOrientationActions;
    private ShowTestHierarchyAction fShowTestHierarchyAction;
    final Image fStackViewIcon;
    final Image fTestRunOKIcon;
    final Image fTestRunFailIcon;
    final Image fTestRunOKDirtyIcon;
    final Image fTestRunFailDirtyIcon;
    final Image fTestIcon;
    final Image fTestOkIcon;
    final Image fTestErrorIcon;
    final ImageDescriptor fSuiteIconDescriptor = BambooImages.getImageDescriptor("obj16/tsuite.gif");
    final ImageDescriptor fSuiteOkIconDescriptor = BambooImages.getImageDescriptor("obj16/tsuiteok.gif");
    final ImageDescriptor fSuiteErrorIconDescriptor = BambooImages.getImageDescriptor("obj16/tsuiteerror.gif");
    final Image fSuiteIcon;
    final Image fSuiteOkIcon;
    final Image fSuiteErrorIcon;
    final List<Image> fImagesToDispose;
    static final String TAG_PAGE = "page";
    static final String TAG_RATIO = "ratio";
    static final String TAG_TRACEFILTER = "tracefilter";
    static final String TAG_ORIENTATION = "orientation";
    static final String TAG_SCROLL = "scroll";
    static final String TAG_LAYOUT = "layout";
    static final String TAG_FAILURES_ONLY = "failuresOnly";
    static final String PREF_LAST_PATH = "lastImportExportPath";
    static final int VIEW_ORIENTATION_VERTICAL = 0;
    static final int VIEW_ORIENTATION_HORIZONTAL = 1;
    static final int VIEW_ORIENTATION_AUTOMATIC = 2;
    private IMemento fMemento;
    Image fOriginalViewImage;
    private SashForm fSashForm;
    private Composite fCounterComposite;
    private Composite fParent;
    public static final Object FAMILY_JUNIT_RUN = new Object();
    private final IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference ref) {
        }

        public void partBroughtToTop(IWorkbenchPartReference ref) {
        }

        public void partInputChanged(IWorkbenchPartReference ref) {
        }

        public void partClosed(IWorkbenchPartReference ref) {
        }

        public void partDeactivated(IWorkbenchPartReference ref) {
        }

        public void partOpened(IWorkbenchPartReference ref) {
        }

        public void partVisible(IWorkbenchPartReference ref) {
            if (TestResultsView.this.getSite().getId().equals(ref.getId())) {
                TestResultsView.this.fPartIsVisible = true;
            }
        }

        public void partHidden(IWorkbenchPartReference ref) {
            if (TestResultsView.this.getSite().getId().equals(ref.getId())) {
                TestResultsView.this.fPartIsVisible = false;
            }
        }
    };
    protected boolean fPartIsVisible = false;

    public TestResultsView() {
        this.fImagesToDispose = MiscUtil.buildArrayList();
        this.fStackViewIcon = this.createManagedImage("eview16/stackframe.gif");
        this.fTestRunOKIcon = this.createManagedImage("eview16/junitsucc.gif");
        this.fTestRunFailIcon = this.createManagedImage("eview16/juniterr.gif");
        this.fTestRunOKDirtyIcon = this.createManagedImage("eview16/junitsuccq.gif");
        this.fTestRunFailDirtyIcon = this.createManagedImage("eview16/juniterrq.gif");
        this.fTestIcon = this.createManagedImage("obj16/test.gif");
        this.fTestOkIcon = this.createManagedImage("obj16/testok.gif");
        this.fTestErrorIcon = this.createManagedImage("obj16/testerr.gif");
        this.fSuiteIcon = this.createManagedImage(this.fSuiteIconDescriptor);
        this.fSuiteOkIcon = this.createManagedImage(this.fSuiteOkIconDescriptor);
        this.fSuiteErrorIcon = this.createManagedImage(this.fSuiteErrorIconDescriptor);
    }

    private Image createManagedImage(String path) {
        return this.createManagedImage(BambooImages.getImageDescriptor(path));
    }

    private Image createManagedImage(ImageDescriptor descriptor) {
        Image image = descriptor.createImage();
        if (image == null) {
            image = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        this.fImagesToDispose.add(image);
        return image;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        this.fMemento = memento;
        IWorkbenchSiteProgressService progressService = this.getProgressService();
        if (progressService != null) {
            progressService.showBusyForFamily(FAMILY_JUNIT_RUN);
        }
    }

    private IWorkbenchSiteProgressService getProgressService() {
        Object siteService = this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (siteService != null) {
            return (IWorkbenchSiteProgressService)siteService;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        if (this.fSashForm == null) {
            if (this.fMemento != null) {
                memento.putMemento(this.fMemento);
            }
            return;
        }
        int[] weigths = this.fSashForm.getWeights();
        int ratio = weigths[0] * 1000 / (weigths[0] + weigths[1]);
        memento.putInteger(TAG_RATIO, ratio);
        memento.putInteger(TAG_ORIENTATION, this.fOrientation);
        memento.putString(TAG_FAILURES_ONLY, this.fFailuresOnlyFilterAction.isChecked() ? "true" : "false");
        memento.putInteger(TAG_LAYOUT, this.fLayout);
    }

    private void restoreLayoutState(IMemento memento) {
        Integer orientation;
        Integer ratio = memento.getInteger(TAG_RATIO);
        if (ratio != null) {
            this.fSashForm.setWeights(new int[]{ratio, 1000 - ratio});
        }
        if ((orientation = memento.getInteger(TAG_ORIENTATION)) != null) {
            this.fOrientation = orientation;
        }
        this.computeOrientation();
        Integer layout = memento.getInteger(TAG_LAYOUT);
        int layoutValue = 1;
        if (layout != null) {
            layoutValue = layout;
        }
        String failuresOnly = memento.getString(TAG_FAILURES_ONLY);
        boolean showFailuresOnly = false;
        if (failuresOnly != null) {
            showFailuresOnly = failuresOnly.equals("true");
        }
        this.setFilterAndLayout(showFailuresOnly, layoutValue);
    }

    private void processChangesInUI() {
        if (this.fSashForm.isDisposed()) {
            return;
        }
        this.doShowInfoMessage();
        this.refreshCounters();
        if (!this.fPartIsVisible) {
            this.updateViewTitleProgress();
        } else {
            this.updateViewIcon();
        }
        boolean hasErrorsOrFailures = this.hasErrorsOrFailures();
        this.fNextAction.setEnabled(hasErrorsOrFailures);
        this.fPreviousAction.setEnabled(hasErrorsOrFailures);
        this.fTestViewer.processChangesInUI();
    }

    public void selectNextFailure() {
        this.fTestViewer.selectFailure(true);
    }

    public void selectPreviousFailure() {
        this.fTestViewer.selectFailure(false);
    }

    protected void selectFirstFailure() {
        this.fTestViewer.selectFirstFailure();
    }

    private boolean hasErrorsOrFailures() {
        return this.getErrorsPlusFailures() > 0;
    }

    private int getErrorsPlusFailures() {
        if (this.fBuildDetails == null) {
            return 0;
        }
        return this.fBuildDetails.getFailedTestDetails().size();
    }

    private String elapsedTimeAsString(long runTime) {
        return NumberFormat.getInstance().format((double)runTime / 1000.0);
    }

    private void handleStopped() {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestResultsView.this.isDisposed()) {
                    return;
                }
                TestResultsView.this.resetViewIcon();
            }
        });
    }

    private void resetViewIcon() {
        this.fViewImage = this.fOriginalViewImage;
        this.firePropertyChange(1);
    }

    private void updateViewIcon() {
        this.fViewImage = this.fBuildDetails == null ? this.fOriginalViewImage : (this.hasErrorsOrFailures() ? this.fTestRunFailIcon : this.fTestRunOKIcon);
        this.firePropertyChange(1);
    }

    private void updateViewTitleProgress() {
        if (this.fBuildDetails != null) {
            this.updateViewIcon();
        } else {
            this.resetViewIcon();
        }
    }

    public synchronized void dispose() {
        this.fIsDisposed = true;
        this.getViewSite().getPage().removePartListener(this.fPartListener);
        this.disposeImages();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
        }
    }

    private void disposeImages() {
        int i = 0;
        while (i < this.fImagesToDispose.size()) {
            this.fImagesToDispose.get(i).dispose();
            ++i;
        }
    }

    private void postSyncRunnable(Runnable r) {
        if (!this.isDisposed()) {
            this.getDisplay().syncExec(r);
        }
    }

    private void refreshCounters() {
        int errorCount;
        int totalCount;
        if (this.fBuildDetails != null) {
            totalCount = this.fBuildDetails.getSuccessfulTestDetails().size() + this.fBuildDetails.getFailedTestDetails().size();
            errorCount = this.fBuildDetails.getFailedTestDetails().size();
        } else {
            totalCount = 0;
            errorCount = 0;
        }
        this.fCounterPanel.setRunValue(totalCount);
        this.fCounterPanel.setErrorValue(errorCount);
    }

    protected void doShowInfoMessage() {
        if (this.fInfoMessage != null) {
            this.setContentDescription(this.fInfoMessage);
            this.fInfoMessage = null;
        }
    }

    protected void registerInfoMessage(String message) {
        this.fInfoMessage = message;
    }

    private SashForm createSashForm(Composite parent) {
        this.fSashForm = new SashForm(parent, 512);
        ViewForm top = new ViewForm((Composite)this.fSashForm, 0);
        Composite empty = new Composite((Composite)top, 0);
        empty.setLayout(new Layout(){

            protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
                return new Point(1, 1);
            }

            protected void layout(Composite composite, boolean flushCache) {
            }
        });
        top.setTopLeft((Control)empty);
        this.fTestViewer = new TestViewer((Composite)top, this.fClipboard, this);
        top.setContent(this.fTestViewer.getTestViewerControl());
        ViewForm bottom = new ViewForm((Composite)this.fSashForm, 0);
        CLabel label = new CLabel((Composite)bottom, 0);
        label.setText("Failures: ");
        label.setImage(this.fStackViewIcon);
        bottom.setTopLeft((Control)label);
        ToolBar failureToolBar = new ToolBar((Composite)bottom, 0x800040);
        bottom.setTopCenter((Control)failureToolBar);
        this.fFailureTrace = new FailureTrace((Composite)bottom, this.fClipboard, this, failureToolBar);
        bottom.setContent((Control)this.fFailureTrace.getComposite());
        this.fSashForm.setWeights(new int[]{50, 50});
        return this.fSashForm;
    }

    private void clearStatus() {
        this.getStatusLine().setMessage(null);
        this.getStatusLine().setErrorMessage(null);
    }

    public void setFocus() {
        if (this.fTestViewer != null) {
            this.fTestViewer.getTestViewerControl().setFocus();
        }
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.addResizeListener(parent);
        this.fClipboard = new Clipboard(parent.getDisplay());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        parent.setLayout((Layout)gridLayout);
        this.configureToolBar();
        this.fCounterComposite = this.createProgressCountPanel(parent);
        this.fCounterComposite.setLayoutData((Object)new GridData(768));
        SashForm sashForm = this.createSashForm(parent);
        sashForm.setLayoutData((Object)new GridData(1808));
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fCopyAction = new JUnitCopyAction(this.fFailureTrace, this.fClipboard);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        this.fOriginalViewImage = this.getTitleImage();
        this.getViewSite().getPage().addPartListener(this.fPartListener);
        this.setFilterAndLayout(false, 1);
        this.fTestViewer.setShowTime(true);
        if (this.fMemento != null) {
            this.restoreLayoutState(this.fMemento);
        }
        this.fMemento = null;
    }

    private void addResizeListener(Composite parent) {
        parent.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TestResultsView.this.computeOrientation();
            }
        });
    }

    void computeOrientation() {
        if (this.fOrientation != 2) {
            this.fCurrentOrientation = this.fOrientation;
            this.setOrientation(this.fCurrentOrientation);
        } else {
            Point size = this.fParent.getSize();
            if (size.x != 0 && size.y != 0) {
                if (size.x > size.y) {
                    this.setOrientation(1);
                } else {
                    this.setOrientation(0);
                }
            }
        }
    }

    private void configureToolBar() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fNextAction = new ShowNextFailureAction(this);
        this.fNextAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        this.fPreviousAction = new ShowPreviousFailureAction(this);
        this.fPreviousAction.setEnabled(false);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAction);
        this.fFailuresOnlyFilterAction = new FailuresOnlyFilterAction();
        this.fToggleOrientationActions = new ToggleOrientationAction[]{new ToggleOrientationAction(0), new ToggleOrientationAction(1), new ToggleOrientationAction(2)};
        this.fShowTestHierarchyAction = new ShowTestHierarchyAction();
        toolBar.add((IAction)this.fNextAction);
        toolBar.add((IAction)this.fPreviousAction);
        toolBar.add((IAction)this.fFailuresOnlyFilterAction);
        toolBar.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.fShowTestHierarchyAction);
        viewMenu.add((IContributionItem)new Separator());
        MenuManager layoutSubMenu = new MenuManager("&Layout");
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            layoutSubMenu.add((IAction)this.fToggleOrientationActions[i]);
            ++i;
        }
        viewMenu.add((IContributionItem)layoutSubMenu);
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.fFailuresOnlyFilterAction);
        actionBars.updateActionBars();
    }

    private IStatusLineManager getStatusLine() {
        IEditorPart activeEditorPart;
        IEditorActionBarContributor contributor;
        IViewSite site = this.getViewSite();
        IWorkbenchPage page = site.getPage();
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof IViewPart) {
            IViewPart activeViewPart = (IViewPart)activePart;
            IViewSite activeViewSite = activeViewPart.getViewSite();
            return activeViewSite.getActionBars().getStatusLineManager();
        }
        if (activePart instanceof IEditorPart && (contributor = (activeEditorPart = (IEditorPart)activePart).getEditorSite().getActionBarContributor()) instanceof EditorActionBarContributor) {
            return ((EditorActionBarContributor)contributor).getActionBars().getStatusLineManager();
        }
        return this.getViewSite().getActionBars().getStatusLineManager();
    }

    protected Composite createProgressCountPanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.setCounterColumns(layout);
        this.fCounterPanel = new CounterPanel(composite);
        this.fCounterPanel.setLayoutData(new GridData(768));
        return composite;
    }

    public void handleTestSelected(TestElement test) {
        this.showFailure(test);
        this.fCopyAction.handleTestSelected(test);
    }

    private void showFailure(final TestElement test) {
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (!TestResultsView.this.isDisposed()) {
                    TestResultsView.this.fFailureTrace.showFailure(test);
                }
            }
        });
    }

    private boolean isDisposed() {
        return this.fIsDisposed || this.fCounterPanel.isDisposed();
    }

    private Display getDisplay() {
        return this.getViewSite().getShell().getDisplay();
    }

    public Image getTitleImage() {
        if (this.fOriginalViewImage == null) {
            this.fOriginalViewImage = super.getTitleImage();
        }
        if (this.fViewImage == null) {
            return super.getTitleImage();
        }
        return this.fViewImage;
    }

    void codeHasChanged() {
        if (this.fViewImage == this.fTestRunOKIcon) {
            this.fViewImage = this.fTestRunOKDirtyIcon;
        } else if (this.fViewImage == this.fTestRunFailIcon) {
            this.fViewImage = this.fTestRunFailDirtyIcon;
        }
        Runnable r = new Runnable(){

            public void run() {
                if (TestResultsView.this.isDisposed()) {
                    return;
                }
                TestResultsView.this.firePropertyChange(1);
            }
        };
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(r);
        }
    }

    public boolean isCreated() {
        return this.fCounterPanel != null;
    }

    private void setOrientation(int orientation) {
        if (this.fSashForm == null || this.fSashForm.isDisposed()) {
            return;
        }
        boolean horizontal = orientation == 1;
        this.fSashForm.setOrientation(horizontal ? 256 : 512);
        int i = 0;
        while (i < this.fToggleOrientationActions.length) {
            this.fToggleOrientationActions[i].setChecked(this.fOrientation == this.fToggleOrientationActions[i].getOrientation());
            ++i;
        }
        this.fCurrentOrientation = orientation;
        GridLayout layout = (GridLayout)this.fCounterComposite.getLayout();
        this.setCounterColumns(layout);
        this.fParent.layout();
    }

    private void setCounterColumns(GridLayout layout) {
        layout.numColumns = this.fCurrentOrientation == 1 ? 2 : 1;
    }

    public FailureTrace getFailureTrace() {
        return this.fFailureTrace;
    }

    void setShowFailuresOnly(boolean failuresOnly) {
        this.setFilterAndLayout(failuresOnly, this.fLayout);
    }

    private void setLayoutMode(int mode) {
        this.setFilterAndLayout(this.fFailuresOnlyFilterAction.isChecked(), mode);
    }

    private void setFilterAndLayout(boolean failuresOnly, int layoutMode) {
        this.fShowTestHierarchyAction.setChecked(layoutMode == 1);
        this.fLayout = layoutMode;
        this.fFailuresOnlyFilterAction.setChecked(failuresOnly);
        this.fTestViewer.setShowFailuresOnly(failuresOnly, layoutMode);
    }

    List<TestDetails> getAllFailures() {
        return this.fBuildDetails.getFailedTestDetails();
    }

    public void setTestsResult(String buildKey, BuildDetails testResults) {
        this.fBuildDetails = testResults;
        if (testResults != null) {
            this.setContentDescription(NLS.bind((String)"Bamboo build {0}", (Object)buildKey));
            this.clearStatus();
            this.fFailureTrace.clear();
            this.fTestViewer.setBuildDetails(buildKey, testResults);
            this.fTestViewer.expandFirstLevel();
        } else {
            this.setContentDescription("");
            this.setTitleToolTip(null);
            this.resetViewIcon();
            this.clearStatus();
            this.fFailureTrace.clear();
            this.registerInfoMessage(" ");
        }
        this.postSyncRunnable(new Runnable(){

            public void run() {
                if (TestResultsView.this.isDisposed()) {
                    return;
                }
                TestResultsView.this.processChangesInUI();
                if (TestResultsView.this.hasErrorsOrFailures()) {
                    TestResultsView.this.selectFirstFailure();
                }
            }
        });
    }

    private class DirtyListener
    implements IElementChangedListener {
        private DirtyListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            this.processDelta(event.getDelta());
        }

        private boolean processDelta(IJavaElementDelta delta) {
            int kind = delta.getKind();
            int details = delta.getFlags();
            int type = delta.getElement().getElementType();
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (kind == 4 && details == 8) break;
                    TestResultsView.this.codeHasChanged();
                    return false;
                }
                case 5: {
                    if ((details & 0x10000) != 0) {
                        return true;
                    }
                    TestResultsView.this.codeHasChanged();
                    return false;
                }
                case 6: {
                    return true;
                }
                default: {
                    TestResultsView.this.codeHasChanged();
                    return false;
                }
            }
            IJavaElementDelta[] affectedChildren = delta.getAffectedChildren();
            if (affectedChildren == null) {
                return true;
            }
            int i = 0;
            while (i < affectedChildren.length) {
                if (!this.processDelta(affectedChildren[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    private class FailuresOnlyFilterAction
    extends Action {
        public FailuresOnlyFilterAction() {
            super("Show &Failures Only", 2);
            this.setToolTipText("Show &Failures Only");
            this.setImageDescriptor(BambooImages.getImageDescriptor("obj16/failures.gif"));
        }

        public void run() {
            TestResultsView.this.setShowFailuresOnly(this.isChecked());
        }
    }

    private class ShowTestHierarchyAction
    extends Action {
        public ShowTestHierarchyAction() {
            super("Show Tests in &Hierarchy", 2);
            this.setImageDescriptor(BambooImages.getImageDescriptor("elcl16/hierarchicalLayout.gif"));
        }

        public void run() {
            int mode = this.isChecked() ? 1 : 0;
            TestResultsView.this.setLayoutMode(mode);
        }
    }

    private class ToggleOrientationAction
    extends Action {
        private final int fActionOrientation;

        public ToggleOrientationAction(int orientation) {
            super("", 8);
            if (orientation == 1) {
                this.setText("&Horizontal View Orientation");
                this.setImageDescriptor(BambooImages.getImageDescriptor("elcl16/th_horizontal.gif"));
            } else if (orientation == 0) {
                this.setText("&Vertical View Orientation");
                this.setImageDescriptor(BambooImages.getImageDescriptor("elcl16/th_vertical.gif"));
            } else if (orientation == 2) {
                this.setText("&Automatic View Orientation");
                this.setImageDescriptor(BambooImages.getImageDescriptor("elcl16/th_automatic.gif"));
            }
            this.fActionOrientation = orientation;
        }

        public int getOrientation() {
            return this.fActionOrientation;
        }

        public void run() {
            if (this.isChecked()) {
                TestResultsView.this.fOrientation = this.fActionOrientation;
                TestResultsView.this.computeOrientation();
            }
        }
    }
}

