/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui;

import com.atlassian.connector.eclipse.internal.bamboo.ui.EclipseBambooBuild;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import com.atlassian.theplugin.commons.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildTreeViewer
extends TreeViewer {
    private volatile boolean disposed = false;

    public BuildTreeViewer(Composite parent, int i) {
        super(parent, i);
        UIJob lastBuildRefreshJob = new UIJob(parent.getDisplay(), "Bamboo View Last Build Refresh Job"){
            private static final long TREE_REFRESH_INTERVAL = 60000L;

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (!BuildTreeViewer.this.disposed) {
                    BuildTreeViewer.this.update();
                    this.schedule(60000L);
                }
                return Status.OK_STATUS;
            }
        };
        lastBuildRefreshJob.setUser(false);
        lastBuildRefreshJob.setSystem(true);
        lastBuildRefreshJob.schedule();
    }

    private void update() {
        if (!this.getTree().isDisposed()) {
            this.update(this.getInput(), new String[]{"org.eclipse.jface.text"});
        }
    }

    public void refresh() {
        this.refresh(this.getRoot());
    }

    public void refresh(Object element, boolean updateLabels) {
        if (this.disposed || this.getTree().isDisposed()) {
            return;
        }
        TreeItem[] selection = this.getTree().getSelection();
        super.refresh(element, updateLabels);
        this.restoreSelection(selection);
    }

    public void refresh(Object element) {
        if (this.disposed || this.getTree().isDisposed()) {
            return;
        }
        TreeItem[] selection = this.getTree().getSelection();
        super.refresh(element);
        this.restoreSelection(selection);
    }

    public void refresh(boolean updateLabels) {
        if (this.disposed || this.getTree().isDisposed()) {
            return;
        }
        TreeItem[] selection = this.getTree().getSelection();
        super.refresh(updateLabels);
        this.restoreSelection(selection);
    }

    public void setBuilds(Collection<EclipseBambooBuild> builds) {
        Object[] expandedElements = super.getExpandedElements();
        TreePath[] expandedTreePaths = super.getExpandedTreePaths();
        super.setInput(builds);
        super.setExpandedElements(expandedElements);
        super.setExpandedTreePaths(expandedTreePaths);
    }

    private Collection<BambooBuild> getSelectedBuilds() {
        TreeItem[] selection;
        ArrayList<BambooBuild> selectedBuilds = new ArrayList<BambooBuild>();
        TreeItem[] treeItemArray = selection = this.getTree().getSelection();
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem selectedItem = treeItemArray[n2];
            if (selectedItem.getData() instanceof EclipseBambooBuild) {
                selectedBuilds.add(((EclipseBambooBuild)selectedItem.getData()).getBuild());
            }
            ++n2;
        }
        return selectedBuilds;
    }

    private void restoreSelectionByBuild(Collection<BambooBuild> selectedBuilds) {
        ArrayList<TreeItem> rewritenSelection = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray = this.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getData() instanceof EclipseBambooBuild) {
                BambooBuild build = ((EclipseBambooBuild)item.getData()).getBuild();
                for (BambooBuild selectedBuild : selectedBuilds) {
                    if (!selectedBuild.getServer().equals((Object)build.getServer()) || !MiscUtil.isEqual((Object)selectedBuild.getProjectName(), (Object)build.getProjectName()) || !selectedBuild.getPlanKey().equals(build.getPlanKey())) continue;
                    rewritenSelection.add(item);
                }
            }
            ++n2;
        }
        this.restoreSelection(rewritenSelection.toArray(new TreeItem[0]));
    }

    private void restoreSelection(TreeItem[] selection) {
        this.getTree().setSelection(selection);
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
    }

    public void dispose() {
        this.disposed = true;
    }

    public Collection<EclipseBambooBuild> getInput() {
        return (Collection)super.getInput();
    }
}

