/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.editors.webflow.graph.parts;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.springframework.ide.eclipse.config.graph.model.Activity;
import org.springframework.ide.eclipse.config.graph.parts.SimpleActivityPart;
import org.springframework.ide.eclipse.config.ui.editors.webflow.graph.StateDirectEditPolicy;
import org.springframework.ide.eclipse.config.ui.editors.webflow.graph.StateNodeEditPolicy;
import org.springframework.ide.eclipse.config.ui.editors.webflow.graph.model.AbstractStateModelElement;

public abstract class AbstractStateGraphicalEditPart
extends SimpleActivityPart {
    public AbstractStateGraphicalEditPart(AbstractStateModelElement state) {
        super((Activity)state);
    }

    protected IFigure createFigure() {
        Label l = (Label)super.createFigure();
        l.setTextPlacement(4);
        return l;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new StateDirectEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new StateNodeEditPolicy());
    }

    protected Dimension getFigureHint() {
        return this.getFigure().getPreferredSize(((Label)this.figure).getIcon().getBounds().width, ((Label)this.figure).getIcon().getBounds().height);
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor(this.getFigure());
    }
}

