/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.ui.actions;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.springframework.ide.eclipse.config.core.contentassist.SpringConfigContentAssistProcessor;
import org.springframework.ide.eclipse.config.ui.actions.Messages;
import org.springframework.ide.eclipse.config.ui.actions.TreeViewerNodeAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class InsertNodeAction
extends TreeViewerNodeAction {
    private final StructuredTextViewer textView;
    private final String childName;

    public InsertNodeAction(TreeViewer treeViewer, SpringConfigContentAssistProcessor processor, StructuredTextViewer textView, String childName) {
        super(treeViewer, processor);
        this.textView = textView;
        this.childName = childName;
        this.setText(String.valueOf(Messages.getString("InsertNodeAction.INSERT_ELEMENT_PREFIX")) + childName + Messages.getString("InsertNodeAction.INSERT_ELEMENT_SUFFIX"));
    }

    @Override
    public void run() {
        super.run();
        IDOMElement selection = this.getElementFromTreeItem(this.getSelectedTreeItem());
        if (this.textView != null && selection != null) {
            IDOMModel model = selection.getModel();
            Document doc = null;
            if (selection instanceof Document) {
                doc = (Document)selection;
            } else if (selection.getOwnerDocument() != null) {
                doc = selection.getOwnerDocument();
            }
            if (model != null && doc != null) {
                model.beginRecording((Object)this.textView);
                IDOMElement child = (IDOMElement)doc.createElement(this.childName);
                selection.appendChild((Node)child);
                this.processor.insertDefaultAttributes(child);
                this.formatter.formatNode((Node)child);
                this.formatter.formatNode(child.getParentNode());
                model.endRecording((Object)this.textView);
                if (this.treeViewer != null) {
                    this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)child));
                }
            }
        }
    }
}

