/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.wizards;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.utils.ArquillianUIUtil;

public abstract class ArquillianWizard
extends Wizard
implements INewWizard {
    private IWorkbench fWorkbench;
    protected static final String DIALOG_SETTINGS_KEY = "ArquillianWizards";
    private IStructuredSelection fSelection;

    public ArquillianWizard() {
        this.setNeedsProgressMonitor(true);
        this.initializeDefaultPageImageDescriptor();
    }

    public abstract boolean performFinish();

    protected boolean finishPage(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            Shell shell = this.getShell();
            String title = "New";
            String message = "Creation of element failed.";
            this.handleException(e, shell, title, message);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void handleException(CoreException e, Shell shell, String title, String message) {
        ArquillianUIActivator.log(e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e.getMessage(), shell, title, message);
        }
    }

    private void handleException(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.handleException((CoreException)target, shell, title, message);
        } else {
            ArquillianUIActivator.log(e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                this.displayMessageDialog(e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(target.getMessage(), shell, title, message);
            }
        }
    }

    private void displayMessageDialog(String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write("See error log for details");
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }

    protected void openResource(final IResource resource) {
        Display display;
        IWorkbenchPage activePage;
        if (resource.getType() == 1 && (activePage = ArquillianUIUtil.getActivePage()) != null && (display = Display.getDefault()) != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)((IFile)resource), (boolean)true);
                    }
                    catch (PartInitException e) {
                        ArquillianUIActivator.log(e);
                    }
                }
            });
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.fWorkbench = workbench;
        this.fSelection = currentSelection;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
    }

    protected void initDialogSettings() {
        IDialogSettings pluginSettings = ArquillianUIActivator.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = pluginSettings.getSection(DIALOG_SETTINGS_KEY);
        if (wizardSettings == null) {
            wizardSettings = new DialogSettings(DIALOG_SETTINGS_KEY);
            pluginSettings.addSection(wizardSettings);
        }
        this.setDialogSettings(wizardSettings);
    }

    protected abstract void initializeDefaultPageImageDescriptor();
}

