/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.arquillian.ui.internal.refactoring;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.arquillian.ui.ArquillianUIActivator;
import org.jboss.tools.arquillian.ui.internal.refactoring.AddMissingTypeRefactoring;

public class AddMissingTypeWizardPage
extends UserInputWizardPage {
    private static final String ADD_ALL_CLASSES = "addAllClasses";
    private static final String MISSING_TYPE_SECTION = "missingTypeSection";
    private AddMissingTypeRefactoring refactoring;
    private Combo deploymentMethodsCombo;
    private IDialogSettings dialogSettings;
    private IDialogSettings section;
    private Button addAllClassesButton;

    public AddMissingTypeWizardPage(AddMissingTypeRefactoring refactoring) {
        super(refactoring.getName());
        this.refactoring = refactoring;
        this.dialogSettings = ArquillianUIActivator.getDefault().getDialogSettings();
        this.section = this.dialogSettings.getSection(MISSING_TYPE_SECTION);
        if (this.section == null) {
            this.section = this.dialogSettings.addNewSection(MISSING_TYPE_SECTION);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        composite.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        Label label = new Label(composite, 0);
        label.setText("Deployment method:");
        this.deploymentMethodsCombo = new Combo(composite, 0);
        this.deploymentMethodsCombo.setItems(this.refactoring.getDeploymentMethodsNames());
        this.deploymentMethodsCombo.select(0);
        this.deploymentMethodsCombo.setLayoutData((Object)new GridData(768));
        this.deploymentMethodsCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AddMissingTypeWizardPage.this.refactoring.setDeploymentMethod(AddMissingTypeWizardPage.this.deploymentMethodsCombo.getText());
                AddMissingTypeWizardPage.this.validate();
            }
        });
        this.addAllClassesButton = new Button(composite, 32);
        this.addAllClassesButton.setText("Add dependent classes");
        this.addAllClassesButton.setLayoutData((Object)new GridData(768));
        boolean addAllClasses = this.section.getBoolean(ADD_ALL_CLASSES);
        this.addAllClassesButton.setSelection(addAllClasses);
        this.refactoring.setAddAllDependentClasses(addAllClasses);
        this.addAllClassesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AddMissingTypeWizardPage.this.refactoring.setAddAllDependentClasses(AddMissingTypeWizardPage.this.addAllClassesButton.getSelection());
            }
        });
        this.setControl((Control)composite);
        this.validate();
    }

    private void validate() {
    }

    protected boolean performFinish() {
        this.section.put(ADD_ALL_CLASSES, this.addAllClassesButton.getSelection());
        return super.performFinish();
    }
}

