/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.refactoring.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.ui.BeansUIPlugin;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.beans.ui.refactoring.actions.AbstractBeansRefactorAction;
import org.springframework.ide.eclipse.beans.ui.refactoring.ltk.RenameIdRefactoring;
import org.springframework.ide.eclipse.beans.ui.refactoring.ltk.RenameIdRefactoringWizard;
import org.springframework.ide.eclipse.beans.ui.refactoring.ltk.RenameIdType;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BeansRenameRefactorAction
extends AbstractBeansRefactorAction {
    private boolean isRenameAvailable(IJavaElement element) throws CoreException {
        switch (element.getElementType()) {
            case 2: {
                return RefactoringAvailabilityTester.isRenameAvailable((IJavaProject)((IJavaProject)element));
            }
            case 3: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragmentRoot)((IPackageFragmentRoot)element));
            }
            case 4: {
                return RefactoringAvailabilityTester.isRenameAvailable((IPackageFragment)((IPackageFragment)element));
            }
            case 5: {
                return RefactoringAvailabilityTester.isRenameAvailable((ICompilationUnit)((ICompilationUnit)element));
            }
            case 7: {
                return RefactoringAvailabilityTester.isRenameAvailable((IType)((IType)element));
            }
            case 9: {
                IMethod method = (IMethod)element;
                if (method.isConstructor()) {
                    return RefactoringAvailabilityTester.isRenameAvailable((IType)method.getDeclaringType());
                }
                return RefactoringAvailabilityTester.isRenameAvailable((IMethod)method);
            }
            case 8: {
                IField field = (IField)element;
                if (Flags.isEnum((int)field.getFlags())) {
                    return RefactoringAvailabilityTester.isRenameEnumConstAvailable((IField)field);
                }
                return RefactoringAvailabilityTester.isRenameFieldAvailable((IField)field);
            }
            case 15: {
                return RefactoringAvailabilityTester.isRenameAvailable((ITypeParameter)((ITypeParameter)element));
            }
            case 14: {
                return RefactoringAvailabilityTester.isRenameAvailable((ILocalVariable)((ILocalVariable)element));
            }
        }
        return false;
    }

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document = this.getTextEditor(event).getDocumentProvider().getDocument((Object)this.getTextEditor(event).getEditorInput());
        if (document != null) {
            ITextSelection textSelection = this.getCurrentSelection(event);
            if (textSelection.isEmpty()) {
                return null;
            }
            Object obj = ((IStructuredSelection)textSelection).getFirstElement();
            Element node = null;
            String attributeName = null;
            if (obj instanceof Attr) {
                Attr attribute = (Attr)obj;
                node = attribute.getOwnerElement();
                attributeName = attribute.getName();
            } else if (obj instanceof Element) {
                node = (Element)obj;
                attributeName = this.getSelectedAttributeName(textSelection);
            }
            if (node != null && attributeName != null) {
                RenameIdType idType = null;
                if ("bean".equals(node.getLocalName()) && "http://www.springframework.org/schema/beans".equals(node.getNamespaceURI()) && "id".equals(attributeName)) {
                    idType = RenameIdType.BEAN;
                } else if ("advice".equals(node.getLocalName()) && "http://www.springframework.org/schema/tx".equals(node.getNamespaceURI()) && "id".equals(attributeName)) {
                    idType = RenameIdType.ADVICE;
                } else if ("pointcut".equals(node.getLocalName()) && "http://www.springframework.org/schema/aop".equals(node.getNamespaceURI()) && "id".equals(attributeName)) {
                    idType = RenameIdType.POINTCUT;
                }
                if (idType != null) {
                    RenameIdRefactoring refactoring = new RenameIdRefactoring();
                    refactoring.setType(idType);
                    refactoring.setNode((IDOMNode)node);
                    refactoring.setBeanId(BeansEditorUtils.getAttribute((Node)node, (String)"id"));
                    refactoring.setFile(this.getConfigFile(event));
                    refactoring.setOffset(textSelection.getOffset());
                    RenameIdRefactoringWizard wizard = new RenameIdRefactoringWizard(refactoring, "Rename " + idType.getType() + " id");
                    this.run(wizard, BeansUIPlugin.getActiveWorkbenchShell(), "Rename " + idType.getType() + " id");
                } else {
                    this.processAction(event, document, textSelection);
                }
            }
        }
        return null;
    }

    @Override
    protected void run(IJavaElement element) throws CoreException {
        if (!this.isRenameAvailable(element) || !ActionUtil.isProcessable((Shell)BeansUIPlugin.getActiveWorkbenchShell(), (IJavaElement)element)) {
            return;
        }
        if (ActionUtil.mustDisableJavaModelAction((Shell)BeansUIPlugin.getActiveWorkbenchShell(), (Object)element)) {
            return;
        }
        RefactoringExecutionStarter.startRenameRefactoring((IJavaElement)element, (Shell)BeansUIPlugin.getActiveWorkbenchShell());
    }

    public void run(RefactoringWizard wizard, Shell parent, String dialogTitle) {
        try {
            RefactoringWizardOpenOperation operation = new RefactoringWizardOpenOperation(wizard);
            operation.run(parent, dialogTitle);
        }
        catch (InterruptedException interruptedException) {}
    }
}

