/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.core.net;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.springsource.ide.eclipse.commons.internal.core.net.ITransportService;

public class JDKTransportService
implements ITransportService {
    private static final int BUFFER_SIZE = 4096;

    @Override
    public void download(URI uri, OutputStream out, IProgressMonitor progressMonitor) throws CoreException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor);
        try {
            URL url = uri.toURL();
            monitor.subTask(NLS.bind((String)"Fetching {0}", (Object)url));
            try {
                InputStream in = url.openStream();
                BufferedInputStream bufferedIn = new BufferedInputStream(in);
                try {
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = ((InputStream)bufferedIn).read(buffer)) != -1) {
                        out.write(buffer, 0, len);
                        monitor.worked(1);
                        monitor.setWorkRemaining(10000);
                        if (!monitor.isCanceled()) continue;
                        throw new OperationCanceledException();
                    }
                }
                finally {
                    ((InputStream)bufferedIn).close();
                    in.close();
                }
            }
            catch (IOException e) {
                throw this.toException(url, e);
            }
        }
        catch (MalformedURLException e) {
            throw this.toException(uri, (IOException)e);
        }
    }

    @Override
    public long getLastModified(URI location, IProgressMonitor monitor) throws CoreException {
        try {
            URL url = location.toURL();
            try {
                return url.openConnection().getLastModified();
            }
            catch (IOException e) {
                throw this.toException(url, e);
            }
        }
        catch (MalformedURLException e) {
            throw this.toException(location, (IOException)e);
        }
    }

    @Override
    public InputStream stream(URI uri, IProgressMonitor monitor) throws CoreException {
        try {
            URL url = uri.toURL();
            try {
                InputStream in = url.openStream();
                return in;
            }
            catch (IOException e) {
                throw this.toException(url, e);
            }
        }
        catch (MalformedURLException e) {
            throw this.toException(uri, (IOException)e);
        }
    }

    private CoreException toException(URI uri, IOException e) throws CoreException {
        String message = e.getMessage() != null ? e.getMessage() : "Unexpected error";
        return new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", NLS.bind((String)"Download of {0} failed: {1}", (Object)uri.getFragment(), (Object)message), (Throwable)e));
    }

    private CoreException toException(URL url, IOException e) throws CoreException {
        String message = e.getMessage() != null ? e.getMessage() : "Unexpected error";
        return new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.commons.core", NLS.bind((String)"Download of {0} failed: {1}", (Object)url, (Object)message), (Throwable)e));
    }
}

