/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.core.commandhistory;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.springsource.ide.eclipse.commons.core.Entry;
import org.springsource.ide.eclipse.commons.core.ICommandHistory;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;
import org.springsource.ide.eclipse.commons.internal.core.commandhistory.ValidProjectFilter;

public class CommandHistory
implements Iterable<Entry>,
ICommandHistory {
    private static final String HISTORY_FILE_NAME = ".commandhistory";
    private int maxSize = 100;
    private boolean isDirty;
    private LinkedList<Entry> history = new LinkedList();
    private final String natureId;
    private final String historyId;

    public CommandHistory(String historyId, String natureId) {
        this.natureId = natureId;
        this.historyId = historyId;
    }

    public CommandHistory(String historyId, String natureId, boolean persist) throws CoreException {
        this.natureId = natureId;
        this.historyId = historyId;
        if (persist) {
            CommandHistorySaver saver = new CommandHistorySaver();
            ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)CorePlugin.getDefault(), (ISaveParticipant)saver);
            this.load(this.getSavePath());
        }
    }

    @Override
    public void add(Entry entry) {
        this.history.remove(entry);
        this.history.addFirst(entry);
        this.discardOldEntries();
        this.isDirty = true;
    }

    @Override
    public void clear() {
        this.history.clear();
        this.isDirty = true;
    }

    private void discardOldEntries() {
        while (this.size() > this.getMaxSize()) {
            this.history.removeLast();
        }
    }

    @Override
    public Entry getLast() {
        return this.history.getFirst();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public List<Entry> getRecentValid(int limit) {
        ArrayList<Entry> result = new ArrayList<Entry>(limit);
        for (Entry entry : this.validEntries()) {
            if (limit-- <= 0) {
                return result;
            }
            result.add(entry);
        }
        return result;
    }

    private IPath getSavePath() {
        return CorePlugin.getDefault().getStateLocation().append(String.valueOf(this.historyId) + HISTORY_FILE_NAME);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean isEmpty() {
        return this.history.isEmpty();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.history.iterator();
    }

    public void load(File file) {
        block8: {
            try {
                if (!file.exists()) break block8;
                FileInputStream fIn = new FileInputStream(file);
                ObjectInputStream oIn = null;
                try {
                    oIn = new ObjectInputStream(fIn);
                    this.load(oIn);
                    this.isDirty = false;
                }
                finally {
                    if (oIn != null) {
                        oIn.close();
                    } else if (fIn != null) {
                        fIn.close();
                    }
                }
            }
            catch (Exception e) {
                CorePlugin.log("Could not restore the command history", e);
                if (!file.exists()) break block8;
                file.delete();
            }
        }
    }

    private void load(IPath savePath) {
        this.load(savePath.toFile());
    }

    private void load(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int newMaxSize = in.readInt();
        Entry[] elements = new Entry[in.readInt()];
        int i = 0;
        while (i < elements.length) {
            elements[i] = (Entry)in.readObject();
            ++i;
        }
        this.maxSize = newMaxSize;
        this.history = new LinkedList();
        Entry[] entryArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Entry element = entryArray[n2];
            this.history.add(element);
            ++n2;
        }
        this.isDirty = false;
    }

    public void save(File file) throws IOException {
        if (this.isDirty()) {
            FileOutputStream fOut = new FileOutputStream(file);
            ObjectOutputStream oOut = null;
            try {
                oOut = new ObjectOutputStream(fOut);
                this.save(oOut);
                this.isDirty = false;
            }
            finally {
                if (oOut != null) {
                    oOut.close();
                } else if (fOut != null) {
                    fOut.close();
                }
            }
        }
    }

    private void save(IPath file) throws IOException {
        this.save(file.toFile());
    }

    private void save(ObjectOutputStream out) throws IOException {
        out.writeInt(this.maxSize);
        out.writeInt(this.size());
        for (Entry entry : this.history) {
            out.writeObject(entry);
        }
    }

    public void setMaxSize(int max) {
        Assert.isLegal((max > 0 ? 1 : 0) != 0);
        this.maxSize = max;
        this.discardOldEntries();
        this.isDirty = true;
    }

    @Override
    public int size() {
        return this.history.size();
    }

    public Entry[] toArray() {
        Entry[] result = new Entry[this.size()];
        int i = 0;
        for (Entry entry : this) {
            result[i++] = entry;
        }
        return result;
    }

    @Override
    public Iterable<Entry> validEntries() {
        return new ValidProjectFilter(this, this.natureId);
    }

    private class CommandHistorySaver
    implements ISaveParticipant {
        private CommandHistorySaver() {
        }

        public void doneSaving(ISaveContext context) {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void rollback(ISaveContext context) {
        }

        public void saving(ISaveContext context) throws CoreException {
            if (CommandHistory.this.isDirty()) {
                try {
                    CommandHistory.this.save(CommandHistory.this.getSavePath());
                }
                catch (Exception e) {
                    throw new CoreException(CorePlugin.createErrorStatus("Couldn't save command history", e));
                }
                context.needSaveNumber();
            }
        }
    }
}

