/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.internal.core;

import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.prefs.Preferences;

public class CorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.springsource.ide.eclipse.commons.core";
    private static CorePlugin plugin;
    private static final String UUID_PROPERTY_KEY = "install.id";

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static synchronized String getUUID() {
        ServiceReference ref = CorePlugin.getDefault().getBundle().getBundleContext().getServiceReference(IPreferencesService.class.getName());
        IPreferencesService prefService = (IPreferencesService)CorePlugin.getDefault().getBundle().getBundleContext().getService(ref);
        try {
            IEclipsePreferences prefs = (IEclipsePreferences)prefService.getRootNode().node("instance");
            Preferences p = prefs.node(PLUGIN_ID);
            if (StringUtils.isEmpty((String)p.get(UUID_PROPERTY_KEY, ""))) {
                p.put(UUID_PROPERTY_KEY, UUID.randomUUID().toString());
            }
            String string = p.get(UUID_PROPERTY_KEY, "");
            return string;
        }
        finally {
            if (prefService != null) {
                CorePlugin.getDefault().getBundle().getBundleContext().ungetService(ref);
            }
        }
    }

    public static void log(IStatus status) {
        CorePlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = CorePlugin.createErrorStatus(message, exception);
        CorePlugin.log(status);
    }

    public static void log(Throwable exception) {
        CorePlugin.log(CorePlugin.createErrorStatus("Internal Error", exception));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        this.savePluginPreferences();
    }

    public static void warn(String msg) {
        CorePlugin.log((IStatus)new Status(2, PLUGIN_ID, msg));
    }
}

