/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springframework.ide.eclipse.boot.core.SpringBootStarter;
import org.springframework.ide.eclipse.boot.core.StarterId;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.ui.OkButtonHandler;

public class AddStarterModel
implements OkButtonHandler {
    private final ISpringBootProject project;
    public final LiveVariable<SpringBootStarter> chosen = new LiveVariable(null);
    public final Validator validator = new Validator(){

        protected ValidationResult compute() {
            try {
                SpringBootStarter starter = (SpringBootStarter)AddStarterModel.this.chosen.getValue();
                if (starter == null) {
                    return ValidationResult.error((String)"No starter selected");
                }
                if (AddStarterModel.this.project.getBootStarters().contains(starter)) {
                    return ValidationResult.error((String)("Starter '" + starter.getLabel() + "' already exists on project '" + AddStarterModel.this.getProjectName() + "'"));
                }
            }
            catch (Exception e) {
                BootActivator.log(e);
                return ValidationResult.error((String)("Unexpected error: " + ExceptionUtil.getMessage((Throwable)e)));
            }
            return ValidationResult.OK;
        }
    };

    public AddStarterModel(IProject project) throws CoreException {
        this.validator.dependsOn(this.chosen);
        this.project = SpringBootCore.create(project);
    }

    public String getProjectName() {
        return this.project.getProject().getName();
    }

    public void performOk() throws CoreException {
        final SpringBootStarter starter = (SpringBootStarter)this.chosen.getValue();
        if (this.chosen.getValue() != null) {
            Job job = new Job("Modifying starters for " + this.getProjectName()){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        AddStarterModel.this.project.addStarter(starter);
                        return Status.OK_STATUS;
                    }
                    catch (CoreException e) {
                        BootActivator.log(e);
                        return ExceptionUtil.status((Throwable)e);
                    }
                }
            };
            job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
            job.schedule();
        }
    }

    public SpringBootStarter[] getAvailableStarters() throws CoreException {
        List<SpringBootStarter> all = this.project.getKnownStarters();
        List<SpringBootStarter> useds = this.project.getBootStarters();
        HashSet<StarterId> usedIds = new HashSet<StarterId>();
        for (SpringBootStarter used : useds) {
            usedIds.add(used.getId());
        }
        ArrayList<SpringBootStarter> available = new ArrayList<SpringBootStarter>();
        for (SpringBootStarter starter : all) {
            if (usedIds.contains(starter.getId())) continue;
            available.add(starter);
        }
        return available.toArray(new SpringBootStarter[available.size()]);
    }
}

