/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.commons.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.progress.UIJob;

public class MigrateToSecureStorageJob
extends UIJob {
    private final String kind;
    private static final MutexRule mutex = new MutexRule();

    public MigrateToSecureStorageJob(String kind) {
        super("Migrating passwords to secure storage");
        this.kind = kind;
        this.setRule(mutex);
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        Set repos = TasksUiPlugin.getRepositoryManager().getRepositories(this.kind);
        if (repos != null) {
            for (TaskRepository repo : repos) {
                MigrateToSecureStorageJob.migrateToSecureStorage(repo);
            }
        }
        return Status.OK_STATUS;
    }

    public static boolean migrateToSecureStorage(TaskRepository repository) {
        if (repository.getProperty("org.eclipse.mylyn.tasklist.repositories.configuration.securestorage") == null && !"local".equals(repository.getUrl())) {
            try {
                AuthenticationCredentials creds = repository.getCredentials(AuthenticationType.REPOSITORY);
                AuthenticationCredentials httpCreds = repository.getCredentials(AuthenticationType.HTTP);
                AuthenticationCredentials proxyCreds = repository.getCredentials(AuthenticationType.PROXY);
                boolean savePassword = repository.getSavePassword(AuthenticationType.REPOSITORY);
                boolean httpSavePassword = repository.getSavePassword(AuthenticationType.HTTP);
                boolean proxySavePassword = repository.getSavePassword(AuthenticationType.PROXY);
                repository.setProperty("org.eclipse.mylyn.tasklist.repositories.configuration.securestorage", "true");
                if (creds != null) {
                    repository.setCredentials(AuthenticationType.REPOSITORY, creds, savePassword);
                }
                if (httpCreds != null) {
                    repository.setCredentials(AuthenticationType.HTTP, httpCreds, httpSavePassword);
                }
                if (proxyCreds != null) {
                    repository.setCredentials(AuthenticationType.PROXY, proxyCreds, proxySavePassword);
                }
                try {
                    Platform.flushAuthorizationInfo((URL)new URL(repository.getUrl()), (String)"", (String)"Basic");
                }
                catch (MalformedURLException malformedURLException) {
                    Platform.flushAuthorizationInfo((URL)new URL("http://eclipse.org/mylyn"), (String)repository.getUrl(), (String)"Basic");
                }
                return true;
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)"Could not migrate credentials to secure storage for {0}", (Object)repository.getUrl()), (Throwable)e));
            }
        }
        return false;
    }

    public static class MutexRule
    implements ISchedulingRule {
        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

