/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.validator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.document.AttrImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.ide.eclipse.beans.core.internal.model.BeansModelUtils;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.BeanDeprecationRule;
import org.springframework.ide.eclipse.beans.core.internal.model.validation.rules.BeanPropertyRule;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansModelElement;
import org.springframework.ide.eclipse.beans.core.model.validation.IBeansValidationContext;
import org.springframework.ide.eclipse.core.internal.model.validation.ValidationRuleDefinition;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.ValidationProblemAttribute;
import org.springframework.ide.eclipse.quickfix.BeansEditorValidator;
import org.springframework.ide.eclipse.quickfix.processors.QuickfixProcessorFactory;
import org.springframework.ide.eclipse.quickfix.validator.BeanValidator;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeanHelper;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeanPropertyHelper;
import org.springframework.ide.eclipse.quickfix.validator.helper.BeansValidationContextHelper;

public class PropertyValidator
extends BeanValidator {
    @Override
    public boolean validateAttributeWithConfig(IBeansConfig config, IResourceModelElement contextElement, IFile file, AttrImpl attribute, IDOMNode parent, IReporter reporter, boolean reportError, BeansEditorValidator validator, String text) {
        IProject project = file.getProject();
        ValidationRuleDefinition propertyRuleDefinition = this.getValidationRule(project, BeanPropertyRule.class);
        BeanPropertyRule propertyRule = (BeanPropertyRule)(propertyRuleDefinition != null ? propertyRuleDefinition.getRule() : null);
        ValidationRuleDefinition depracationRuleDefinition = this.getValidationRule(project, BeanDeprecationRule.class);
        BeanDeprecationRule deprecationRule = (BeanDeprecationRule)(depracationRuleDefinition != null ? depracationRuleDefinition.getRule() : null);
        IDOMNode parentBeanNode = this.getParentBeanNode(parent);
        if (parentBeanNode == null) {
            return false;
        }
        BeanHelper parentBean = new BeanHelper(parentBeanNode, file, project);
        BeansValidationContextHelper context = new BeansValidationContextHelper(attribute, parent, contextElement, project, reporter, validator, QuickfixProcessorFactory.PROPERTY, false, reportError, config);
        BeanPropertyHelper property = new BeanPropertyHelper(parent, file, parentBean);
        if (propertyRule != null) {
            context.setCurrentRuleDefinition(propertyRuleDefinition);
            propertyRule.validate((IBeanProperty)property, (IBeansValidationContext)context, null);
        }
        if (context.getErrorFound()) {
            return true;
        }
        context = new BeansValidationContextHelper(attribute, parent, contextElement, project, reporter, validator, QuickfixProcessorFactory.DEPRECATED, false, reportError, config);
        ITextRegion valueRegion = attribute.getValueRegion();
        AbstractBeanDefinition mergedBd = (AbstractBeanDefinition)BeansModelUtils.getMergedBeanDefinition((IBean)parentBean, (IModelElement)context.getContextElement());
        String mergedClassName = mergedBd.getBeanClassName();
        if (valueRegion != null && mergedClassName != null) {
            validator.createAndAddEmptyMessage(valueRegion, parent, "", reporter, QuickfixProcessorFactory.RENAME_PROPERTY, null, new ValidationProblemAttribute("CLASS", (Object)mergedClassName));
        }
        if (deprecationRule != null) {
            context.setCurrentRuleDefinition(depracationRuleDefinition);
            deprecationRule.validate((IBeansModelElement)property, (IBeansValidationContext)context, null);
        }
        return context.getErrorFound();
    }
}

