/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.refresh;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.reconcile.DirtyRegionProcessor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorPart;
import org.springframework.ide.eclipse.config.core.IConfigEditor;
import org.springframework.util.ReflectionUtils;

public class RefreshUtils {
    public static void refreshCurrentEditor(IResource resource) {
        HashSet<IResource> resources = new HashSet<IResource>();
        resources.add(resource);
        RefreshUtils.refreshEditors(resources);
    }

    public static void refreshEditors(Set<IResource> resources) {
        IWorkbenchWindow[] workbenchWindows;
        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = workbenchWindows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage[] pages;
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            IWorkbenchPage[] iWorkbenchPageArray = pages = workbenchWindow.getPages();
            int n3 = pages.length;
            int n4 = 0;
            while (n4 < n3) {
                IEditorReference[] editorReferences;
                IWorkbenchPage page = iWorkbenchPageArray[n4];
                IEditorReference[] iEditorReferenceArray = editorReferences = page.getEditorReferences();
                int n5 = editorReferences.length;
                int n6 = 0;
                while (n6 < n5) {
                    IEditorReference editorReference = iEditorReferenceArray[n6];
                    IWorkbenchPart part = editorReference.getPart(false);
                    if (part != null && !part.getSite().getShell().isDisposed()) {
                        RefreshUtils.refreshEditor(part, resources);
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void refreshEditor(final IWorkbenchPart part, final Set<IResource> resources) {
        part.getSite().getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IFile file;
                if (!(part instanceof IConfigEditor) && !(part instanceof XMLMultiPageEditorPart)) {
                    return;
                }
                IEditorInput input = ((IEditorPart)part).getEditorInput();
                if (input instanceof IFileEditorInput && (!resources.contains(file = ((IFileEditorInput)input).getFile()) || resources.size() == 0)) {
                    return;
                }
                StructuredTextEditor textEditor = null;
                if (part instanceof IConfigEditor) {
                    IConfigEditor editor = (IConfigEditor)part;
                    textEditor = editor.getSourcePage();
                } else if (part instanceof XMLMultiPageEditorPart) {
                    IEditorPart[] editors;
                    XMLMultiPageEditorPart xmlEditor = (XMLMultiPageEditorPart)part;
                    IEditorPart[] iEditorPartArray = editors = xmlEditor.findEditors(xmlEditor.getEditorInput());
                    int n = editors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorPart editor = iEditorPartArray[n2];
                        if (editor instanceof StructuredTextEditor) {
                            textEditor = (StructuredTextEditor)editor;
                        }
                        ++n2;
                    }
                }
                if (textEditor != null) {
                    StructuredTextViewer textViewer;
                    IReconciler reconciler;
                    SourceViewerConfiguration configuration = null;
                    try {
                        Method getSourceViewerConfigurationMethod = ReflectionUtils.findMethod(textEditor.getClass(), (String)"getSourceViewerConfiguration");
                        getSourceViewerConfigurationMethod.setAccessible(true);
                        configuration = (SourceViewerConfiguration)getSourceViewerConfigurationMethod.invoke((Object)textEditor, new Object[0]);
                    }
                    catch (Exception exception) {}
                    if (configuration != null && (reconciler = configuration.getReconciler((ISourceViewer)(textViewer = textEditor.getTextViewer()))) instanceof DirtyRegionProcessor) {
                        ((DirtyRegionProcessor)reconciler).setDocument(textViewer.getDocument());
                    }
                }
            }
        });
    }
}

