/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.quickfix.jdt.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.ui.text.java.IInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.quickfix.jdt.processors.AbstractAnnotationQuickAssistProcessor;
import org.springframework.ide.eclipse.quickfix.jdt.proposals.AddExceptionHandlerCompletionProposal;
import org.springframework.ide.eclipse.quickfix.jdt.util.ProposalCalculatorUtil;

public class ExceptionHandlerAnnotationQuickAssistProcessor
extends AbstractAnnotationQuickAssistProcessor {
    private List<Class<?>> exceptions;

    @Override
    public String getAnnotationName() {
        return "ExceptionHandler";
    }

    @Override
    public boolean isQuickfixAvailable(FieldDeclaration fieldDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public boolean isQuickfixAvailable(MethodDeclaration methodDecl, IInvocationContext context) {
        TypeDeclaration typeDecl = this.getSurroundingTypeDecl((ASTNode)methodDecl);
        if (typeDecl != null && ProposalCalculatorUtil.hasAnnotation("Controller", (ASTNode)typeDecl) && !ProposalCalculatorUtil.hasAnnotation("ExceptionHandler", (ASTNode)methodDecl)) {
            Class<?> exceptionType;
            List params = methodDecl.parameters();
            ClassLoader classLoader = JdtUtils.getProjectClassLoaderSupport((IProject)context.getCompilationUnit().getJavaProject().getProject(), (ClassLoader)BeansCorePlugin.getClassLoader()).getProjectClassLoader();
            try {
                exceptionType = classLoader.loadClass(Exception.class.getCanonicalName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return false;
            }
            for (SingleVariableDeclaration param : params) {
                Class<?> paramClass;
                ITypeBinding paramTypeBinding = param.getType().resolveBinding();
                String paramTypeName = paramTypeBinding.getQualifiedName();
                try {
                    paramClass = classLoader.loadClass(paramTypeName);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    continue;
                }
                if (!exceptionType.isAssignableFrom(paramClass)) continue;
                this.exceptions.add(paramClass);
            }
        }
        return this.exceptions.size() > 0;
    }

    @Override
    public boolean isQuickfixAvailable(TypeDeclaration typeDecl, IInvocationContext context) {
        return false;
    }

    @Override
    public List<IJavaCompletionProposal> getAssistsForMethod(MethodDeclaration methodDecl, SimpleName name, ICompilationUnit cu) {
        ArrayList<IJavaCompletionProposal> proposals = new ArrayList<IJavaCompletionProposal>();
        List<String> exceptionNames = ExceptionHandlerAnnotationQuickAssistProcessor.groupExceptions(this.exceptions);
        proposals.add((IJavaCompletionProposal)new AddExceptionHandlerCompletionProposal(methodDecl, exceptionNames, cu));
        return proposals;
    }

    private static List<String> groupExceptions(List<Class<?>> exceptions) {
        ArrayList storedExceptions = new ArrayList();
        for (Class<?> newException : exceptions) {
            boolean isSubclass = false;
            for (Class clazz : storedExceptions) {
                if (!clazz.isAssignableFrom(newException)) continue;
                isSubclass = true;
                break;
            }
            if (isSubclass) continue;
            ArrayList<Class> arrayList = new ArrayList<Class>();
            for (Class clazz : storedExceptions) {
                if (!newException.isAssignableFrom(clazz)) continue;
                arrayList.add(clazz);
            }
            storedExceptions.removeAll(arrayList);
            storedExceptions.add(newException);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (Class clazz : storedExceptions) {
            result.add(clazz.getSimpleName());
        }
        return result;
    }

    @Override
    protected void setUpFields() {
        this.exceptions = new ArrayList();
    }
}

