/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.cordovasim.model.preferences;

import org.jboss.tools.browsersim.browser.IBrowser;
import org.jboss.tools.browsersim.browser.IBrowserFunction;
import org.jboss.tools.cordovasim.CordovaSimArgs;
import org.jboss.tools.cordovasim.model.preferences.CordovaSimSpecificPreferences;

public class InitRipplePreferences
implements IBrowserFunction {
    private IBrowser browser;
    private CordovaSimSpecificPreferences sp;

    public InitRipplePreferences(IBrowser browser, CordovaSimSpecificPreferences sp) {
        this.browser = browser;
        this.sp = sp;
    }

    public Object function(Object[] arguments) {
        String ripplePreferences = this.sp.getRipplePreferences();
        if (ripplePreferences != null) {
            this.initPreferences(ripplePreferences);
        }
        this.overrideProxySettingIfNeeded();
        return null;
    }

    private void initPreferences(String ripplePreferences) {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.browser.execute("(function() {var defaultValues = " + ripplePreferences + ";" + "window.localStorage2.setItem('ripple', JSON.stringify(defaultValues));" + "})();");
        }
    }

    private void overrideProxySettingIfNeeded() {
        String overridenProxy = CordovaSimArgs.getProxy();
        if (overridenProxy != null && this.browser != null && !this.browser.isDisposed()) {
            this.browser.execute("(function() {window.csOverridenProxy = '" + overridenProxy + "';" + "})();");
        }
    }
}

