/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.dialogs;

import ognl.Ognl;
import ognl.OgnlException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IDecisionState;
import org.springframework.ide.eclipse.webflow.core.model.IIf;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelDecorator;
import org.springframework.ide.eclipse.webflow.ui.graph.model.WebflowModelLabelProvider;

public class IfPropertiesDialog
extends TitleAreaDialog {
    private static final String EXPRESSION_PREFIX = "${";
    private static final String EXPRESSION_SUFFIX = "}";
    private Button browseElseButton;
    private Button browseThenButton;
    private SelectionListener buttonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            IfPropertiesDialog.this.handleButtonPressed((Button)e.widget);
        }
    };
    private IIf cloneIf;
    private Text elseText;
    private boolean isNew = false;
    private int LABEL_WIDTH = 70;
    private Button ognlButton;
    private Button okButton;
    private Text onText;
    private IDecisionState parent;
    private IIf theIf;
    private Text thenText;

    public IfPropertiesDialog(Shell parentShell, IDecisionState parent, IIf state, boolean newMode) {
        super(parentShell);
        this.theIf = state;
        this.parent = parent;
        this.cloneIf = (IIf)((ICloneableModelElement)this.theIf).cloneModelElement();
        this.isNew = newMode;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.cloneIf.setTest(this.trimString(this.getTest()));
            if (this.isNew) {
                if (this.thenText != null && this.thenText.getText() != null) {
                    "".equals(this.thenText.getText());
                }
                if (this.elseText != null && this.elseText.getText() != null) {
                    "".equals(this.elseText.getText());
                }
            }
            ((ICloneableModelElement)this.theIf).applyCloneValues((IWebflowModelElement)this.cloneIf);
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getShellTitle());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.onText.setFocus();
        if (this.theIf != null && this.theIf.getTest() != null) {
            this.okButton.setEnabled(true);
        } else {
            this.okButton.setEnabled(false);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(this.getTitle());
        this.setMessage(this.getMessage());
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Composite nameGroup = new Composite(composite, 0);
        nameGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout1 = new GridLayout();
        layout1.numColumns = 2;
        layout1.marginWidth = 5;
        nameGroup.setLayout((Layout)layout1);
        Label onLabel = new Label(nameGroup, 0);
        onLabel.setText("Test");
        this.onText = new Text(nameGroup, 2052);
        if (this.theIf != null && this.theIf.getTest() != null) {
            this.onText.setText(this.theIf.getTest());
        }
        this.onText.setLayoutData((Object)new GridData(768));
        this.onText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IfPropertiesDialog.this.validateInput();
            }
        });
        new Label(nameGroup, 0);
        this.ognlButton = new Button(nameGroup, 32);
        this.ognlButton.setText("Parse OGNL transition criteria");
        this.ognlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IfPropertiesDialog.this.validateInput();
            }
        });
        if (this.isNew) {
            Group groupActionType = new Group(composite, 0);
            GridLayout layoutAttMap = new GridLayout();
            layoutAttMap.marginWidth = 3;
            layoutAttMap.marginHeight = 3;
            groupActionType.setLayout((Layout)layoutAttMap);
            groupActionType.setText(" Transition Tragets ");
            groupActionType.setLayoutData((Object)new GridData(768));
            Composite methodComposite = new Composite((Composite)groupActionType, 0);
            methodComposite.setLayoutData((Object)new GridData(768));
            GridLayout layout3 = new GridLayout();
            layout3.marginHeight = 3;
            layout3.marginWidth = 5;
            layout3.numColumns = 3;
            methodComposite.setLayout((Layout)layout3);
            Label thenLabel = new Label(methodComposite, 0);
            GridData gridData = new GridData(32);
            gridData.widthHint = this.LABEL_WIDTH;
            thenLabel.setLayoutData((Object)gridData);
            thenLabel.setText("Then");
            this.thenText = new Text(methodComposite, 2052);
            this.thenText.setEditable(false);
            if (this.theIf != null && this.theIf.getThenTransition() != null && this.theIf.getThenTransition().getToState() != null) {
                this.thenText.setText(this.theIf.getThenTransition().getToState().getId());
            }
            this.thenText.setLayoutData((Object)new GridData(768));
            this.thenText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IfPropertiesDialog.this.validateInput();
                }
            });
            this.browseThenButton = new Button(methodComposite, 8);
            this.browseThenButton.setText("...");
            this.browseThenButton.setLayoutData((Object)new GridData(128));
            this.browseThenButton.addSelectionListener(this.buttonListener);
            Label elseLabel = new Label(methodComposite, 0);
            gridData = new GridData(32);
            gridData.widthHint = this.LABEL_WIDTH;
            elseLabel.setLayoutData((Object)gridData);
            this.elseText = new Text(methodComposite, 2052);
            if (this.theIf != null && this.theIf.getElseTransition() != null && this.theIf.getElseTransition().getToState() != null) {
                this.elseText.setText(this.theIf.getElseTransition().getToState().getId());
            }
            this.elseText.setLayoutData((Object)new GridData(768));
            this.elseText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    IfPropertiesDialog.this.validateInput();
                }
            });
            this.browseElseButton = new Button(methodComposite, 8);
            this.browseElseButton.setText("...");
            this.browseElseButton.setLayoutData((Object)new GridData(128));
            this.browseElseButton.addSelectionListener(this.buttonListener);
        }
        IfPropertiesDialog.applyDialogFont((Control)parentComposite);
        return parentComposite;
    }

    private String cutExpression(String encodedCriteria) {
        return encodedCriteria.substring(EXPRESSION_PREFIX.length(), encodedCriteria.length() - EXPRESSION_SUFFIX.length());
    }

    public String getMessage() {
        return "Enter the details for the if criteria";
    }

    public IWebflowModelElement getModelElementParent() {
        return this.parent;
    }

    protected String getShellTitle() {
        return "If";
    }

    public String getTest() {
        return this.onText.getText();
    }

    protected String getTitle() {
        return "If properties";
    }

    private void handleButtonPressed(Button button) {
        if (button.equals(this.browseThenButton)) {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator()));
            dialog.setBlockOnOpen(true);
            dialog.setElements(WebflowModelXmlUtils.getStates((IWebflowModelElement)this.parent, (boolean)false).toArray());
            dialog.setEmptySelectionMessage("Enter a valid state id");
            dialog.setTitle("State reference");
            dialog.setMessage("Please select a state reference");
            dialog.setMultipleSelection(false);
            if (dialog.open() == 0) {
                this.thenText.setText(((IState)dialog.getFirstResult()).getId());
            }
        } else {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new DecoratingLabelProvider((ILabelProvider)new WebflowModelLabelProvider(), (ILabelDecorator)new WebflowModelLabelDecorator()));
            dialog.setBlockOnOpen(true);
            dialog.setElements(WebflowModelXmlUtils.getStates((IWebflowModelElement)this.parent, (boolean)false).toArray());
            dialog.setEmptySelectionMessage("Enter a valid state id");
            dialog.setTitle("State reference");
            dialog.setMessage("Please select a state reference");
            dialog.setMultipleSelection(false);
            if (dialog.open() == 0) {
                this.elseText.setText(((IState)dialog.getFirstResult()).getId());
            }
        }
        this.validateInput();
    }

    protected void handleTableSelectionChanged() {
    }

    protected void showError(String error) {
        super.setErrorMessage(error);
    }

    public String trimString(String string) {
        if (string != null && string == "") {
            string = null;
        }
        return string;
    }

    protected void validateInput() {
        String thenTxt;
        String id = this.onText.getText();
        boolean error = false;
        String errorMessage = null;
        if (id == null || "".equals(id)) {
            errorMessage = "A valid test criteria is required. ";
            error = true;
        }
        if (this.ognlButton.getSelection()) {
            if (!id.startsWith(EXPRESSION_PREFIX) || !id.endsWith(EXPRESSION_SUFFIX)) {
                errorMessage = "A valid OGNL expression needs to start with '${' and ends with '}'. ";
                error = true;
            } else {
                try {
                    Ognl.parseExpression((String)this.cutExpression(id));
                }
                catch (OgnlException ognlException) {
                    errorMessage = "Malformed OGNL expression. ";
                    error = true;
                }
            }
        }
        if (this.isNew && ((thenTxt = this.thenText.getText()) == null || "".equals(thenTxt))) {
            errorMessage = "A valid then transition target is required. ";
            error = true;
        }
        if (error) {
            this.getButton(0).setEnabled(false);
            this.setErrorMessage(errorMessage);
        } else {
            this.getButton(0).setEnabled(true);
            this.setErrorMessage(null);
        }
    }
}

