/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.ui.graph.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.springframework.ide.eclipse.webflow.core.model.IIfTransition;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IStateTransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.ITransitionableTo;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.ide.eclipse.webflow.ui.graph.dialogs.DialogUtils;

public class CreateStateCommand
extends Command {
    private IState child;
    private int index = -1;
    private IWebflowState parent;
    private List<ITransition> targetConnections = new ArrayList<ITransition>();
    private int result;

    private void deleteConnections(IState a) {
        if (a instanceof ITransitionableTo) {
            this.targetConnections.addAll(((ITransitionableTo)a).getInputTransitions());
        }
        int i = 0;
        while (i < this.targetConnections.size()) {
            IStateTransition t;
            if (this.targetConnections.get(i) instanceof IStateTransition) {
                t = (IStateTransition)this.targetConnections.get(i);
                t.setToState(null);
                t.getFromState().fireStructureChange("outputs", (Object)t);
            }
            if (this.targetConnections.get(i) instanceof IIfTransition) {
                t = (IIfTransition)this.targetConnections.get(i);
                t.setToState(null);
                ((IWebflowModelElement)t.getElementParent()).fireStructureChange("outputs", (Object)t);
            }
            ++i;
        }
    }

    public void execute() {
        this.child.createNew(this.parent);
        this.result = DialogUtils.openPropertiesDialog((IWebflowModelElement)this.parent, (IWebflowModelElement)this.child, true);
        if (this.result != 0) {
            return;
        }
        if (this.index > 0) {
            this.parent.addState(this.child, this.index);
        } else {
            this.parent.addState(this.child);
        }
    }

    public void redo() {
        if (this.result != 0) {
            return;
        }
        if (this.index > 0) {
            this.parent.addState(this.child, this.index);
        } else {
            this.parent.addState(this.child);
        }
    }

    public void setChild(IState activity) {
        this.child = activity;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setParent(IWebflowState sa) {
        this.parent = sa;
    }

    public void undo() {
        this.parent.removeState(this.child);
        this.deleteConnections(this.child);
    }
}

