/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui;

import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.ui.ImageDescriptorRegistry;
import org.springframework.ide.eclipse.ui.SpringUIImages;
import org.springframework.ide.eclipse.ui.SpringUILabelProvider;
import org.springframework.ide.eclipse.ui.SpringUIMessages;

public class SpringUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.ui";
    public static final String SORTING_ENABLED_KEY = "org.springframework.ide.eclipse.ui.sortingEnabled";
    public static final String SPRING_EXPLORER_ID = "org.springframework.ide.eclipse.ui.navigator.springExplorer";
    public static final String PROJECT_EXPLORER_CONTENT_PROVIDER_ID = "org.springframework.ide.eclipse.ui.navigator.projectExplorerContent";
    public static final String SPRING_EXPLORER_CONTENT_PROVIDER_ID = "org.springframework.ide.eclipse.ui.navigator.springExplorerContent";
    private static SpringUIPlugin plugin;
    private ResourceBundle resourceBundle;
    private ImageDescriptorRegistry imageDescriptorRegistry;
    private ILabelProvider labelProvider;

    public SpringUIPlugin() {
        plugin = this;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        SpringUIImages.initializeImageRegistry(registry);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
        if (this.imageDescriptorRegistry != null) {
            this.imageDescriptorRegistry.dispose();
            this.imageDescriptorRegistry = null;
        }
        super.stop(context);
    }

    public static ImageDescriptorRegistry getImageDescriptorRegistry() {
        return SpringUIPlugin.getDefault().internalGetImageDescriptorRegistry();
    }

    private synchronized ImageDescriptorRegistry internalGetImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = new ImageDescriptorRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public static ILabelProvider getLabelProvider() {
        return SpringUIPlugin.getDefault().internalGetLabelProvider();
    }

    private synchronized ILabelProvider internalGetLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new SpringUILabelProvider(true);
        }
        return this.labelProvider;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return SpringUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static SpringUIPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return SpringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        return SpringUIPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchPage getActiveWorkbenchPage() {
        return SpringUIPlugin.getActiveWorkbenchWindow().getActivePage();
    }

    public static boolean isDebug(String option) {
        String value = Platform.getDebugOption((String)option);
        return value != null && value.equalsIgnoreCase("true");
    }

    public static void log(IStatus status) {
        SpringUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(String message, Throwable exception) {
        IStatus status = SpringUIPlugin.createErrorStatus(message, exception);
        SpringUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable exception) {
        SpringUIPlugin.getDefault().getLog().log(SpringUIPlugin.createErrorStatus(SpringUIMessages.Plugin_internalError, exception));
    }

    public static IStatus createErrorStatus(String message, Throwable exception) {
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }
}

