/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.util;

import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.FormPage;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.commons.ui.ICoreRunnable;
import org.springsource.ide.eclipse.commons.ui.UiStatusHandler;
import org.springsource.ide.eclipse.commons.ui.UiUtil;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;

public class IdeUiUtils {
    public static final String ID_PAGE_FACTORY_CONTEXT = "org.eclipse.mylyn.context.ui.pageFactory.Context";
    public static final String ID_PAGE_FACTORY_JIRA = "org.eclipse.mylyn.jira.ui.pageFactory";
    public static final String JIRA_CONNECTOR_KIND = "jira";
    public static final String JIRA_ATTRIBUTE_COMPONENTS = "attribute.jira.components";
    public static final String JIRA_ATTRIBUTE_AFFECTS_VERSION = "attribute.jira.affectsversions";
    public static final String JIRA_ATTRIBUTE_TYPE = "attribute.jira.type";
    public static final String JIRA_ATTRIBUTE_DESCRIPTION = "task.common.description";
    public static final String JIRA_ATTRIBUTE_PRIORITY = "task.common.priority";
    public static final String JIRA_ATTRIBUTE_SUMMARY = "task.common.summary";
    private static final String ID_PLATFORM_BUNDLE = "org.eclipse.platform";

    public static void closeEditor(FormPage page) {
        if (page.getSite() != null && page.getSite().getPage() != null && !page.getManagedForm().getForm().isDisposed()) {
            if (page.getEditor() != null) {
                page.getSite().getPage().closeEditor((IEditorPart)page.getEditor(), false);
            } else {
                page.getSite().getPage().closeEditor((IEditorPart)page, false);
            }
        }
    }

    public static TaskData createAnalysisTaskData(TaskRepository taskRepository, String description) throws CoreException {
        TaskData taskData = IdeUiUtils.createTaskData(taskRepository, "Runtime Error Knowledge Base");
        if (taskData == null) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not create new repository item"));
        }
        IdeUiUtils.setAttributeValue(taskData, JIRA_ATTRIBUTE_COMPONENTS, "Runtime Error Analysis");
        IdeUiUtils.setAttributeValue(taskData, JIRA_ATTRIBUTE_AFFECTS_VERSION, "1.0M3");
        IdeUiUtils.setAttributeValue(taskData, JIRA_ATTRIBUTE_TYPE, "Analysis");
        IdeUiUtils.setAttributeValue(taskData, JIRA_ATTRIBUTE_DESCRIPTION, description);
        return taskData;
    }

    public static TaskData createBugTaskData(TaskRepository taskRepository, String description) throws CoreException {
        TaskData taskData = IdeUiUtils.createTaskData(taskRepository, "SpringSource Tool Suite");
        if (taskData == null) {
            throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not create new repository item"));
        }
        IdeUiUtils.setAttributeValue(taskData, JIRA_ATTRIBUTE_COMPONENTS, "Unknown");
        IdeUiUtils.setAttributeValue(taskData, JIRA_ATTRIBUTE_AFFECTS_VERSION, IdeUiUtils.getVersion().toString());
        IdeUiUtils.setAttributeValue(taskData, JIRA_ATTRIBUTE_TYPE, "Bug");
        IdeUiUtils.setAttributeValue(taskData, JIRA_ATTRIBUTE_DESCRIPTION, description);
        return taskData;
    }

    public static IRepositoryQuery createQuery(String repositoryUrl, String queryLabel, String queryUrl) {
        TaskRepository taskRepository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl);
        if (taskRepository == null) {
            StatusHandler.log((IStatus)new Status(2, "org.springsource.ide.eclipse.dashboard.ui", "Query initialization failed, repository configuration not found: " + repositoryUrl));
            return null;
        }
        IRepositoryQuery query = IdeUiUtils.getQuery(queryLabel);
        if (query != null) {
            return query;
        }
        query = TasksUi.getRepositoryModel().createRepositoryQuery(taskRepository);
        query.setUrl(queryUrl);
        query.setSummary(queryLabel);
        TasksUiPlugin.getTaskList().addQuery((RepositoryQuery)query);
        TasksUiInternal.synchronizeRepository((TaskRepository)taskRepository, (boolean)false);
        return query;
    }

    public static String createRegularExpression(String expression) {
        expression = expression.replaceAll("\\\\", "\\\\\\\\");
        expression = expression.replaceAll("\\(", "\\\\(");
        expression = expression.replaceAll("\\)", "\\\\)");
        expression = expression.replaceAll("\\[", "\\\\[");
        expression = expression.replaceAll("\\]", "\\\\]");
        expression = expression.replaceAll("\\$", "\\\\\\$");
        return expression;
    }

    private static TaskData createTaskData(final TaskRepository taskRepository, final String projectKey) throws CoreException {
        AbstractRepositoryConnector connector = TasksUi.getRepositoryConnector((String)JIRA_CONNECTOR_KIND);
        final AbstractTaskDataHandler taskDataHandler = connector.getTaskDataHandler();
        final TaskData taskData = new TaskData(taskDataHandler.getAttributeMapper(taskRepository), JIRA_CONNECTOR_KIND, taskRepository.getRepositoryUrl(), "");
        ICoreRunnable runner = new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                TaskMapping mapping = new TaskMapping(){

                    public String getProduct() {
                        return projectKey;
                    }
                };
                if (!taskDataHandler.initializeTaskData(taskRepository, taskData, (ITaskMapping)mapping, monitor)) {
                    throw new CoreException((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "The repository does not have a project with key: " + projectKey));
                }
            }
        };
        UiUtil.busyCursorWhile((ICoreRunnable)runner);
        return taskData;
    }

    public static IRepositoryQuery getBugsQuery() {
        return IdeUiUtils.getQuery("My SpringSource Issues");
    }

    public static Version getPlatformVersion() {
        Bundle bundle = Platform.getBundle((String)ID_PLATFORM_BUNDLE);
        if (bundle == null) {
            bundle = Platform.getBundle((String)"org.eclipse.core.runtime");
        }
        if (bundle != null) {
            String versionString = (String)bundle.getHeaders().get("Bundle-Version");
            try {
                return new Version(versionString);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return Version.emptyVersion;
    }

    private static IRepositoryQuery getQuery(String queryLabel) {
        TaskList taskList = TasksUiPlugin.getTaskList();
        Set queries = taskList.getQueries();
        for (RepositoryQuery query : queries) {
            if (!queryLabel.equals(query.getSummary())) continue;
            return query;
        }
        return null;
    }

    public static IRepositoryQuery getRuntimeErrorAnalysisQuery() {
        return IdeUiUtils.getQuery("My Runtime Error Analyses");
    }

    public static String getShortVersion() {
        Version version = IdeUiUtils.getVersion();
        return String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro();
    }

    private static TaskRepository getTaskRepository(String repositoryUrl) {
        return IdeUiUtils.getTaskRepository(JIRA_CONNECTOR_KIND, repositoryUrl);
    }

    public static TaskRepository getTaskRepository(String connectorKind, String repositoryUrl) {
        Assert.isNotNull((Object)repositoryUrl);
        TaskRepository taskRepository = TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryUrl);
        if (taskRepository == null) {
            taskRepository = new TaskRepository(connectorKind, repositoryUrl);
            Set templates = TasksUiPlugin.getRepositoryTemplateManager().getTemplates(connectorKind);
            for (RepositoryTemplate template : templates) {
                if (!repositoryUrl.equals(template.repositoryUrl)) continue;
                taskRepository.setRepositoryLabel(template.label);
            }
            TasksUi.getRepositoryManager().addRepository(taskRepository);
        }
        return taskRepository;
    }

    public static Version getVersion() {
        return IdeUiPlugin.getDefault().getBundle().getVersion();
    }

    public static void openNewRuntimeErrorAnalysisEditor(String runtimeErrorMessage) {
        try {
            TaskRepository taskRepository = IdeUiUtils.getTaskRepository("https://issuetracker.springsource.com");
            if (taskRepository == null) {
                UiStatusHandler.logAndDisplay((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Please create a Jira repository with the following URL in the Task Repositories view: https://issuetracker.springsource.com"));
                return;
            }
            TaskData taskData = IdeUiUtils.createAnalysisTaskData(taskRepository, runtimeErrorMessage);
            if (taskData != null) {
                TasksUiInternal.createAndOpenNewTask((TaskData)taskData);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (PartInitException e) {
            IdeUiPlugin.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not open runtime error analysis editor", (Throwable)e));
        }
        catch (CoreException e) {
            UiStatusHandler.logAndDisplay((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not open runtime error analysis editor: " + e.getMessage()));
        }
    }

    public static void reportBug(String description) {
        try {
            TaskRepository taskRepository = IdeUiUtils.getTaskRepository("https://issuetracker.springsource.com");
            TaskData taskData = IdeUiUtils.createBugTaskData(taskRepository, description);
            if (taskData != null) {
                TasksUiInternal.createAndOpenNewTask((TaskData)taskData);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
        }
        catch (PartInitException e) {
            IdeUiPlugin.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not open editor", (Throwable)e));
        }
        catch (CoreException e) {
            UiStatusHandler.logAndDisplay((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "Could not open editor: " + e.getMessage()));
        }
    }

    private static void setAttributeValue(TaskData taskData, String attributeId, String value) {
        TaskAttribute attribute = taskData.getRoot().getAttribute(attributeId);
        if (attribute != null && !attribute.getMetaData().isReadOnly()) {
            if (attribute.getOptions().isEmpty()) {
                attribute.setValue(value);
            } else {
                for (Map.Entry entry : attribute.getOptions().entrySet()) {
                    if (!((String)entry.getValue()).equals(value)) continue;
                    attribute.setValue((String)entry.getKey());
                    break;
                }
            }
        }
    }
}

