/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.dashboard.internal.ui.editors;

import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.springsource.ide.eclipse.commons.core.StatusHandler;
import org.springsource.ide.eclipse.dashboard.internal.ui.IdeUiPlugin;
import org.springsource.ide.eclipse.dashboard.internal.ui.editors.FeedsReader;

public class CachedFeedsManager {
    private final Map<String, String> hashedFeedsToIconsMap;
    private final String feedName;
    private static final String DIRECTORY_FEED = "feeds";
    private final FeedsReader reader;

    public CachedFeedsManager(String feedName, Map<String, String> feedsToIconsMap, FeedsReader reader) {
        this.feedName = feedName;
        this.reader = reader;
        this.hashedFeedsToIconsMap = new HashMap<String, String>();
        for (String feed : feedsToIconsMap.keySet()) {
            this.hashedFeedsToIconsMap.put(Integer.toString(feed.hashCode()), feedsToIconsMap.get(feed));
        }
    }

    public void cacheFeeds(Map<String, String> feedToContent) throws IOException {
        File folder = new File(this.getCacheFolderPath().toOSString());
        if (folder.exists()) {
            File[] fileArray = folder.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                file.delete();
                ++n2;
            }
        } else {
            folder.mkdirs();
        }
        for (String url : feedToContent.keySet()) {
            String content = feedToContent.get(url);
            if (content.length() <= 0) continue;
            File file = this.getCachedFeed(url);
            FileWriter writer = new FileWriter(file);
            writer.write(content.toString().toCharArray());
            writer.close();
        }
    }

    private File getCachedFeed(String feedUrl) {
        File file = new File(this.getCacheFolderPath().append(String.valueOf(feedUrl.hashCode()) + ".xml").toOSString());
        return file;
    }

    private File[] getCachedFeeds() {
        File folder = new File(this.getCacheFolderPath().toOSString());
        if (folder.exists() && folder.isDirectory()) {
            return folder.listFiles();
        }
        return new File[0];
    }

    private IPath getCacheFolderPath() {
        IPath folderPath = Platform.getStateLocation((Bundle)IdeUiPlugin.getDefault().getBundle()).append(DIRECTORY_FEED).append(this.feedName);
        return folderPath;
    }

    public void readCachedFeeds(IProgressMonitor monitor) throws FeedException {
        File[] cachedFiles;
        SyndFeedInput input = new SyndFeedInput();
        File[] fileArray = cachedFiles = this.getCachedFeeds();
        int n = cachedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File cachedFile = fileArray[n2];
            String fileName = cachedFile.getName().replaceAll(".xml", "");
            String iconPath = this.hashedFeedsToIconsMap.get(fileName);
            try {
                this.reader.readFeeds(new FileReader(cachedFile), input, iconPath);
            }
            catch (FileNotFoundException e) {
                StatusHandler.log((IStatus)new Status(4, "org.springsource.ide.eclipse.dashboard.ui", "An unexpected error occurred while retrieving feed content from cache.", (Throwable)e));
            }
            ++n2;
        }
    }
}

